package ext.view {
import ext.Component;
import ext.data.Model;
import ext.data.Store;
import ext.grid.CellContext;
import ext.grid.column.Column;
import ext.grid.feature.Feature;
import ext.mixin.IQueryable;

import js.HTMLElement;

[Native("Ext.view.Table", require)]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CLICK
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CLICK
 */
[Event(name='onBeforeCellClick', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CONTEXT_MENU
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_CONTEXT_MENU
 */
[Event(name='onBeforeCellContextMenu', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_DBLCLICK
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_DBLCLICK
 */
[Event(name='onBeforeCellDblclick', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_KEY_DOWN
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_KEY_DOWN
 */
[Event(name='onBeforeCellKeyDown', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_DOWN
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_DOWN
 */
[Event(name='onBeforeCellMouseDown', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_UP
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.BEFORE_CELL_MOUSE_UP
 */
[Event(name='onBeforeCellMouseUp', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CLICK
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CLICK
 */
[Event(name='onBeforeRowBodyClick', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CONTEXT_MENU
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_CONTEXT_MENU
 */
[Event(name='onBeforeRowBodyContextMenu', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_DBLCLICK
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_DBLCLICK
 */
[Event(name='onBeforeRowBodyDblclick', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_DOWN
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_DOWN
 */
[Event(name='onBeforeRowBodyKeyDown', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEYPRESS
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEYPRESS
 */
[Event(name='onBeforeRowBodyKeypress', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_UP
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_KEY_UP
 */
[Event(name='onBeforeRowBodyKeyUp', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_LONG_PRESS
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_LONG_PRESS
 */
[Event(name='onBeforeRowBodyLongPress', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_DOWN
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_DOWN
 */
[Event(name='onBeforeRowBodyMouseDown', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_UP
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.BEFORE_ROW_BODY_MOUSE_UP
 */
[Event(name='onBeforeRowBodyMouseUp', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_keyEvent_prevRow_nextRow_forwardEvent.BEFORE_ROW_EXIT
 * @eventType ext.view.events.TableView_keyEvent_prevRow_nextRow_forwardEvent.BEFORE_ROW_EXIT
 */
[Event(name='onBeforeRowExit', type='ext.view.events.TableView_keyEvent_prevRow_nextRow_forwardEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CLICK
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CLICK
 */
[Event(name='onCellClick', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CONTEXT_MENU
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_CONTEXT_MENU
 */
[Event(name='onCellContextMenu', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_DBLCLICK
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_DBLCLICK
 */
[Event(name='onCellDblclick', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_KEY_DOWN
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_KEY_DOWN
 */
[Event(name='onCellKeyDown', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_DOWN
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_DOWN
 */
[Event(name='onCellMouseDown', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_UP
 * @eventType ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent.CELL_MOUSE_UP
 */
[Event(name='onCellMouseUp', type='ext.view.events.TableView_td_cellIndex_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_CLICK
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_CLICK
 */
[Event(name='onRowBodyClick', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_CONTEXT_MENU
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_CONTEXT_MENU
 */
[Event(name='onRowBodyContextMenu', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_DBLCLICK
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_DBLCLICK
 */
[Event(name='onRowBodyDblclick', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEY_DOWN
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEY_DOWN
 */
[Event(name='onRowBodyKeyDown', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEYPRESS
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEYPRESS
 */
[Event(name='onRowBodyKeypress', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEY_UP
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_KEY_UP
 */
[Event(name='onRowBodyKeyUp', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_LONG_PRESS
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_LONG_PRESS
 */
[Event(name='onRowBodyLongPress', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_DOWN
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_DOWN
 */
[Event(name='onRowBodyMouseDown', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_UP
 * @eventType ext.view.events.TableView_view_rowBodyEl_eEvent.ROW_BODY_MOUSE_UP
 */
[Event(name='onRowBodyMouseUp', type='ext.view.events.TableView_view_rowBodyEl_eEvent')]
/**
 * @see ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_CLICK
 * @eventType ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_CLICK
 */
[Event(name='onRowClick', type='ext.view.events.TableView_record_element_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_record_tr_rowIndex_eEvent.ROW_CONTEXT_MENU
 * @eventType ext.view.events.TableView_record_tr_rowIndex_eEvent.ROW_CONTEXT_MENU
 */
[Event(name='onRowContextMenu', type='ext.view.events.TableView_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_DBLCLICK
 * @eventType ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_DBLCLICK
 */
[Event(name='onRowDblclick', type='ext.view.events.TableView_record_element_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_KEY_DOWN
 * @eventType ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_KEY_DOWN
 */
[Event(name='onRowKeyDown', type='ext.view.events.TableView_record_element_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_record_tr_rowIndex_eEvent.ROW_MOUSE_DOWN
 * @eventType ext.view.events.TableView_record_tr_rowIndex_eEvent.ROW_MOUSE_DOWN
 */
[Event(name='onRowMouseDown', type='ext.view.events.TableView_record_tr_rowIndex_eEvent')]
/**
 * @see ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_MOUSE_UP
 * @eventType ext.view.events.TableView_record_element_rowIndex_eEvent.ROW_MOUSE_UP
 */
[Event(name='onRowMouseUp', type='ext.view.events.TableView_record_element_rowIndex_eEvent')]
/**
 * This class encapsulates the user interface for a tabular data set.
 * It acts as a centralized manager for controlling the various interface
 * elements of the view. This includes handling events, such as row and cell
 * level based DOM events. It also reacts to events from the underlying →<code>ext.selection.SelectionModel</code>
 * to provide visual feedback to the user.
 * <p>This class does not provide ways to manipulate the underlying data of the configured
 * →<code>ext.data.Store</code>.</p>
 * <p>This is the base class for both →<code>ext.view.TableView</code> and →<code>ext.tree.TreeView</code> and is not
 * to be used directly.</p>
 * @see ext.selection.SelectionModel
 * @see ext.data.Store
 * @see ext.view.TableView
 * @see ext.tree.TreeView
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html Original Ext JS documentation of 'Ext.view.Table'
 */
public class TableView extends DataView implements IQueryable {
  /**
   * @param config @inheritDoc
   */
  public function TableView(config:TableView = null) {
    super();
  }

  /**
   * This value is <code>true</code> when the grid has been set to actionable mode by the user.
   * <p>See http://www.w3.org/TR/2013/WD-wai-aria-practices-20130307/#grid</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#property-actionableMode Original Ext JS documentation of 'actionableMode'
   */
  public native function get actionableMode():Boolean;

  [ExtConfig]
  /**
   * True to enable text selection inside this view.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#cfg-enableTextSelection Original Ext JS documentation of 'enableTextSelection'
   */
  public native function get enableTextSelection():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set enableTextSelection(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class to add to the <i>first</i> cell in every row to enable special styling
   * for the first column.
   * If no styling is needed on the first column, this may be configured as <code>null</code>.
   * @default 'x-grid-cell-first'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#cfg-firstCls Original Ext JS documentation of 'firstCls'
   */
  public native function get firstCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set firstCls(value:String):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Ext.view.TableView,
   * or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#property-isTableView Original Ext JS documentation of 'isTableView'
   */
  public native function get isTableView():Boolean;

  /**
   * @private
   */
  public native function set isTableView(value:Boolean):void;

  [ExtConfig]
  /**
   * A CSS class to add to the <i>last</i> cell in every row to enable special styling
   * for the last column.
   * If no styling is needed on the last column, this may be configured as <code>null</code>.
   * @default 'x-grid-cell-last'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#cfg-lastCls Original Ext JS documentation of 'lastCls'
   */
  public native function get lastCls():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set lastCls(value:String):void;

  [ExtConfig]
  /**
   * True to show the dirty cell indicator when a cell has been modified.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#cfg-markDirty Original Ext JS documentation of 'markDirty'
   */
  public native function get markDirty():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set markDirty(value:Boolean):void;

  [ExtConfig]
  /**
   * True to stripe the rows.
   * <p>This causes the CSS class <b><code>x-grid-row-alt</code></b> to be added to alternate rows of
   * the grid. A default CSS rule is provided which sets a background color, but you can override
   * this with a rule which either overrides the <b>background-color</b> style using the <code>!important</code>
   * modifier, or which uses a CSS selector of higher specificity.</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#cfg-stripeRows Original Ext JS documentation of 'stripeRows'
   */
  public native function get stripeRows():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stripeRows(value:Boolean):void;

  /**
   * Adds a CSS Class to a specific row.
   * @param rowInfo An HTMLElement,
   * index or instance of a model representing this row
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-addRowCls Original Ext JS documentation of 'addRowCls'
   */
  public native function addRowCls(rowInfo:*, cls:String):void;

  /**
   * Sizes the passed header to fit the max content width.
   * <i>Note that group columns shrinkwrap around the size of leaf columns. Auto sizing
   * a group column autosizes descendant leaf columns.</i>
   * @param header The header (or index of header) to auto size.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-autoSizeColumn Original Ext JS documentation of 'autoSizeColumn'
   */
  public native function autoSizeColumn(header:*):void;

  /**
   * @inheritDoc
   */
  public native function child(selector:* = undefined):Component;

  /**
   * Disable this view.
   * <p>Disables interaction with, and masks this view.</p>
   * <p>Note that the encapsulating →<code>ext.panel.TablePanel</code> panel is <i>not</i> disabled, and other
   * <i>docked</i> components such as the panel header, the column header container, and docked
   * toolbars will still be enabled. The panel itself can be disabled if that is required,
   * or individual docked components could be disabled.</p>
   * <p>See <i>disableColumnHeaders disableColumnHeaders</i> (→<code>ext.panel.TablePanel</code>) and
   * <i>enableColumnHeaders enableColumnHeaders</i> (→<code>ext.panel.TablePanel</code>).</p>
   * @since 1.1.0
   * @param silent Passing <code>true</code> will suppress the <code>disable</code> event
   * from being fired.
   * @default false
   * @see ext.panel.TablePanel
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-disable Original Ext JS documentation of 'disable'
   */
  override public native function disable(silent:Boolean = false):void;

  /**
   * @inheritDoc
   */
  public native function down(selector:* = undefined):Component;

  [Deprecated(replacement="autoSizeColumn", since="6.5.0")]
  /**
   * Expands a particular header to fit the max content width.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-expandToFit Original Ext JS documentation of 'expandToFit'
   */
  public native function expandToFit(header:*):void;

  /**
   * Focuses a particular cell and brings it into view. Will fire the rowfocus event.
   * @param position The cell to select
   * @param delay Delay the focus this number of milliseconds
   * (true for 10 milliseconds).
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-focusCell Original Ext JS documentation of 'focusCell'
   */
  public native function focusCell(position:CellContext, delay:* = undefined):void;

  /**
   * Focuses a particular row and brings it into view. Will fire the rowfocus event.
   * @param rec The record associated to the node that is to be focused.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-focusNode Original Ext JS documentation of 'focusNode'
   */
  override public native function focusNode(rec:Model):void;

  /**
   * Focuses a particular row and brings it into view. Will fire the rowfocus event.
   * @param row An HTMLElement template node,
   * index of a template node, the id of a template node or the
   * @param delay Delay the focus this number of milliseconds
   * (true for 10 milliseconds). record associated with the node.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-focusRow Original Ext JS documentation of 'focusRow'
   */
  public native function focusRow(row:*, delay:* = undefined):void;

  /**
   * Returns a CSS selector which selects the outermost element(s) in this view.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getBodySelector Original Ext JS documentation of 'getBodySelector'
   */
  public native function getBodySelector():String;

  /**
   * Returns a CSS selector which selects a particular column if the desired header is passed,
   * or a general cell selector is no parameter is passed.
   * @param header The column for which to return the selector. If
   * omitted, the general cell selector which matches <b>ant cell</b> will be returned.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getCellSelector Original Ext JS documentation of 'getCellSelector'
   */
  public native function getCellSelector(header:Column = null):String;

  /**
   * Returns a CSS selector which selects the element(s) which define the width of a column.
   * <p>This is used by the →<code>null</code> when resizing columns.</p>
   * @see null
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getColumnSizerSelector Original Ext JS documentation of 'getColumnSizerSelector'
   */
  public native function getColumnSizerSelector(header:*):String;

  /**
   * Get a reference to a feature
   * @param id The id of the feature
   * @return The feature. Undefined if not found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getFeature Original Ext JS documentation of 'getFeature'
   */
  public native function getFeature(id:String):Feature;

  /**
   * Returns a CSS selector which selects items of the view rendered by the outerRowTpl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getItemSelector Original Ext JS documentation of 'getItemSelector'
   */
  public native function getItemSelector():String;

  /**
   * Returns the table row given the passed Record, or index or node.
   * @param nodeInfo The node or record, or row index.
   * to return the top level row.
   * @return The node or null if it wasn't found
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getRow Original Ext JS documentation of 'getRow'
   */
  public native function getRow(nodeInfo:*):HTMLElement;

  /**
   * Override this function to apply custom CSS classes to rows during rendering. This function
   * should return the CSS class name (or empty string '' for none) that will be added
   * to the row's wrapping element. To apply multiple class names, simply return them
   * space-delimited within the string (e.g. 'my-class another-class').
   * Example usage:
   * <pre>
   * viewConfig: {
   *     getRowClass: function(record, rowIndex, rowParams, store){
   *         return record.get("valid") ? "row-valid" : "row-error";
   *     }
   * }
   * </pre>
   * @param record The record corresponding to the current row.
   * @param index The row index.
   * @param rowParams <b>DEPRECATED.</b> For row body use the
   * →<code>ext.grid.feature.RowBody.getAdditionalData()</code> method of the rowbody
   * feature.
   * @param store The store this grid is bound to
   * @return a CSS class name to add to the row.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-getRowClass Original Ext JS documentation of 'getRowClass'
   * @see ext.grid.feature.RowBody#getAdditionalData()
   */
  public native function getRowClass(record:Model, index:Number, rowParams:Object, store:Store):String;

  /**
   * @inheritDoc
   */
  public native function query(selector:String = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryBy(fn:Function, scope:Object = null):Array;

  /**
   * @inheritDoc
   */
  public native function queryById(id:String):Component;

  /**
   * Refreshes the grid view. Sets the sort state and focuses the previously focused row.
   * <p><b>Note:</b> This method should only be used when <code>bufferedRenderer</code> is set to <code>false</code>.
   * BufferedRender has its own methods for managing its data's state.</p>
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-refresh Original Ext JS documentation of 'refresh'
   */
  override public native function refresh():void;

  /**
   * Removes a CSS Class from a specific row.
   * @param rowInfo An HTMLElement,
   * index or instance of a model representing this row
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-removeRowCls Original Ext JS documentation of 'removeRowCls'
   */
  public native function removeRowCls(rowInfo:*, cls:String):void;

  /**
   * @inheritDoc
   */
  public native function visitPostOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * @inheritDoc
   */
  public native function visitPreOrder(selector:Object, fn:Function, scope:Object = null, extraArgs:Array = null):void;

  /**
   * Navigates from the passed record by the passed increment which may be +ve or -ve.
   * <p>Skips hidden records.</p>
   * <p>If no record is visible in the specified direction, returns the starting record
   * index unchanged.</p>
   * @param startRec The Record to start from.
   * @param distance The distance to move from the record. May be +ve or -ve.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#method-walkRecs Original Ext JS documentation of 'walkRecs'
   */
  public native function walkRecs(startRec:Model, distance:Number):void;
}
}