package ext.view {
import ext.data.Model;
import ext.dd.DragZone;
import ext.event.Event;

import js.HTMLElement;

[Native("Ext.view.DragZone", require)]
[ExtConfig]
/**
 * <b>NOTE: This is a private utility class for internal use by the framework. Don't rely on its existence.</b>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.DragZone.html Original Ext JS documentation of 'Ext.view.DragZone'
 */
public class ViewDragZone extends DragZone {
  /**
   * @inheritDoc
   */
  public function ViewDragZone(config:ViewDragZone = null) {
    super(undefined);
  }

  /**
   * Template method called upon mousedown. May be overridden in subclasses, or configured
   * into an instance.
   * <p>Return <code>true</code> to prevent drag start.</p>
   * @param e The mousedown event.
   * @param record The record mousedowned upon.
   * @param item The grid row mousedowned upon.
   * @param index The row number mousedowned upon.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.DragZone.html#method-isPreventDrag Original Ext JS documentation of 'isPreventDrag'
   */
  protected native function isPreventDrag(e:Event, record:Model, item:HTMLElement, index:Number):void;
}
}