package ext.view.events {
import ext.view.DataView;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.AbstractViewEvent")]
public class AbstractViewEvent extends FlExtEvent {
  /**
   * Fires before the view is refreshed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-beforerefresh Original Ext JS documentation of 'beforerefresh'
   * @see ext.view.AbstractView
   * @eventType onBeforeRefresh
   */
  public static const BEFORE_REFRESH:String = "onBeforeRefresh";
  /**
   * Fires when the view is refreshed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-refresh Original Ext JS documentation of 'refresh'
   * @see ext.view.AbstractView
   * @eventType onRefresh
   */
  public static const REFRESH:String = "onRefresh";
  /**
   * Fires when the View's item elements representing Store items has been rendered.
   * No items will be available for selection until this event fires.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-viewready Original Ext JS documentation of 'viewready'
   * @see ext.view.AbstractView
   * @eventType onViewReady
   */
  public static const VIEW_READY:String = "onViewReady";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "eOpts"];

  public function AbstractViewEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The DataView object
   */
  public native function get source():DataView;
}
}