package ext.view.events {
import ext.data.Model;
import ext.view.DataView;

import js.HTMLElement;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.AbstractView_record_index_node_viewEvent")]
public class AbstractView_record_index_node_viewEvent extends FlExtEvent {
  /**
   * Fires when the node associated with an individual record is updated
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-itemupdate Original Ext JS documentation of 'itemupdate'
   * @see ext.view.AbstractView
   * @eventType onItemUpdate
   */
  public static const ITEM_UPDATE:String = "onItemUpdate";
  public static const __PARAMETER_SEQUENCE__:Array = ["record", "index", "node", "view", "eOpts"];

  public function AbstractView_record_index_node_viewEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index of the record
   */
  public native function get index():Number;

  /**
   * The node that has just been updated
   */
  public native function get node():HTMLElement;

  /**
   * The model instance
   */
  public native function get record():Model;

  /**
   * The view containing the item
   */
  public native function get view():DataView;
}
}