package ext.view.events {
import ext.view.DataView;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.AbstractView_records_index_item_viewEvent")]
public class AbstractView_records_index_item_viewEvent extends FlExtEvent {
  /**
   * Fires when the node associated with an individual record is removed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-itemremove Original Ext JS documentation of 'itemremove'
   * @see ext.view.AbstractView
   * @eventType onItemRemove
   */
  public static const ITEM_REMOVE:String = "onItemRemove";
  public static const __PARAMETER_SEQUENCE__:Array = ["records", "index", "item", "view", "eOpts"];

  public function AbstractView_records_index_item_viewEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index from which the records wer removed
   */
  public native function get index():Number;

  [ArrayElementType("js.HTMLElement")]
  /**
   * The view items removed
   */
  public native function get item():Array;

  [ArrayElementType("ext.data.Model")]
  /**
   * The model instances removed
   */
  public native function get records():Array;

  /**
   * The view removing the item
   */
  public native function get view():DataView;
}
}