package ext.view.events {
import ext.view.DataView;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.AbstractView_records_index_node_viewEvent")]
public class AbstractView_records_index_node_viewEvent extends FlExtEvent {
  /**
   * Fires when the nodes associated with an recordset have been added to the underlying store
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.AbstractView.html#event-itemadd Original Ext JS documentation of 'itemadd'
   * @see ext.view.AbstractView
   * @eventType onItemAdd
   */
  public static const ITEM_ADD:String = "onItemAdd";
  public static const __PARAMETER_SEQUENCE__:Array = ["records", "index", "node", "view", "eOpts"];

  public function AbstractView_records_index_node_viewEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The index at which the set of records was inserted
   */
  public native function get index():Number;

  [ArrayElementType("js.HTMLElement")]
  /**
   * The node that has just been updated
   */
  public native function get node():Array;

  [ArrayElementType("ext.data.Model")]
  /**
   * The model instance
   */
  public native function get records():Array;

  /**
   * The view adding the item
   */
  public native function get view():DataView;
}
}