package ext.view.events {
import ext.dom.Element;
import ext.view.DataView;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.DataView_nodeEvent")]
public class DataView_nodeEvent extends FlExtEvent {
  /**
   * Fires when a node is highlighted using keyboard navigation, or mouseover.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html#event-highlightitem Original Ext JS documentation of 'highlightitem'
   * @see ext.view.DataView
   * @eventType onHighlightItem
   */
  public static const HIGHLIGHT_ITEM:String = "onHighlightItem";
  /**
   * Fires when a node is unhighlighted using keyboard navigation, or mouseout.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.View.html#event-unhighlightitem Original Ext JS documentation of 'unhighlightitem'
   * @see ext.view.DataView
   * @eventType onUnhighlightItem
   */
  public static const UNHIGHLIGHT_ITEM:String = "onUnhighlightItem";
  public static const __PARAMETER_SEQUENCE__:Array = ["view", "node", "eOpts"];

  public function DataView_nodeEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The highlighted node.
   */
  public native function get node():Element;

  /**
   * This View Component.
   */
  public native function get view():DataView;
}
}