package ext.view.events {
import ext.event.Event;
import ext.view.TableView;

import js.HTMLElement;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.TableView_keyEvent_prevRow_nextRow_forwardEvent")]
public class TableView_keyEvent_prevRow_nextRow_forwardEvent extends FlExtEvent {
  /**
   * Fired when View is asked to exit Actionable mode in the current row,
   * and proceed to the previous/next row. If the handler returns <code>false</code>,
   * View processing is aborted.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-beforerowexit Original Ext JS documentation of 'beforerowexit'
   * @see ext.view.TableView
   * @eventType onBeforeRowExit
   */
  public static const BEFORE_ROW_EXIT:String = "onBeforeRowExit";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "keyEvent", "prevRow", "nextRow", "forward", "eOpts"];

  public function TableView_keyEvent_prevRow_nextRow_forwardEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * <code>true</code> if we're navigating forward (Tab), <code>false</code> if
   * navigating backward (Shift-Tab).
   */
  public native function get forward():Boolean;

  /**
   * The key event that caused navigation.
   */
  public native function get keyEvent():Event;

  /**
   * Table row that is going to be focused and activated.
   */
  public native function get nextRow():HTMLElement;

  /**
   * Currently active table row.
   */
  public native function get prevRow():HTMLElement;

  public native function get source():TableView;
}
}