package ext.view.events {
import ext.data.Model;
import ext.event.Event;
import ext.view.TableView;

import js.HTMLElement;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.TableView_record_element_rowIndex_eEvent")]
public class TableView_record_element_rowIndex_eEvent extends FlExtEvent {
  /**
   * Fired when a table row is clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowclick Original Ext JS documentation of 'rowclick'
   * @see ext.view.TableView
   * @eventType onRowClick
   */
  public static const ROW_CLICK:String = "onRowClick";
  /**
   * Fired when table row is double clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowdblclick Original Ext JS documentation of 'rowdblclick'
   * @see ext.view.TableView
   * @eventType onRowDblclick
   */
  public static const ROW_DBLCLICK:String = "onRowDblclick";
  /**
   * Fired when the keydown event is captured on the row.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowkeydown Original Ext JS documentation of 'rowkeydown'
   * @see ext.view.TableView
   * @eventType onRowKeyDown
   */
  public static const ROW_KEY_DOWN:String = "onRowKeyDown";
  /**
   * Fired when the mouseup event is captured on the row.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowmouseup Original Ext JS documentation of 'rowmouseup'
   * @see ext.view.TableView
   * @eventType onRowMouseUp
   */
  public static const ROW_MOUSE_UP:String = "onRowMouseUp";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "record", "element", "rowIndex", "e", "eOpts"];

  public function TableView_record_element_rowIndex_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * <ul>
   * <li><code>position:ext.grid.CellContext</code> (optional) —
   * A CellContext object which defines
   * the target row.
   * </li>
   * </ul>
   */
  public native function get e():Event;

  /**
   * The TR element for the row.
   */
  public native function get element():HTMLElement;

  public native function get record():Model;

  public native function get rowIndex():Number;

  public native function get source():TableView;
}
}