package ext.view.events {
import ext.data.Model;
import ext.event.Event;
import ext.view.TableView;

import js.HTMLElement;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.view.events.TableView_record_tr_rowIndex_eEvent")]
public class TableView_record_tr_rowIndex_eEvent extends FlExtEvent {
  /**
   * Fired when table row is right clicked.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowcontextmenu Original Ext JS documentation of 'rowcontextmenu'
   * @see ext.view.TableView
   * @eventType onRowContextMenu
   */
  public static const ROW_CONTEXT_MENU:String = "onRowContextMenu";
  /**
   * Fired when the mousedown event is captured on the row.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.view.Table.html#event-rowmousedown Original Ext JS documentation of 'rowmousedown'
   * @see ext.view.TableView
   * @eventType onRowMouseDown
   */
  public static const ROW_MOUSE_DOWN:String = "onRowMouseDown";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "record", "tr", "rowIndex", "e", "eOpts"];

  public function TableView_record_tr_rowIndex_eEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * <ul>
   * <li><code>position:ext.grid.CellContext</code> (optional) —
   * A CellContext object which defines
   * the target row.
   * </li>
   * </ul>
   */
  public native function get e():Event;

  public native function get record():Model;

  public native function get rowIndex():Number;

  public native function get source():TableView;

  /**
   * The TR element for the row.
   */
  public native function get tr():HTMLElement;
}
}