package ext.window {

[Native("Ext.window.Toast", require)]
/**
 * This class provides for lightweight, auto-dismissing pop-up notifications called "toasts".
 * At the base level, you can display a toast message by calling <code>Ext.toast</code> like so:
 * <pre>
 *  Ext.toast('Data saved');
 * </pre>
 * <p>This will result in a toast message, which displays in the default location at the top
 * of your viewport.</p>
 * <p>You may expand upon this simple example with the following parameters:</p>
 * <pre>
 *  Ext.toast(message, title, align, iconCls);
 * </pre>
 * <p>For example, the following toast will appear top-middle in your viewport. It will display
 * the 'Data Saved' message with a title of 'Title'</p>
 * <pre>
 *  Ext.toast('Data Saved', 'Title', 't')
 * </pre>
 * <p>It should be noted that the toast's width is determined by the message's width.
 * If you need to set a specific width, or any of the other available configurations for your toast,
 * you can create the toast object as seen below:</p>
 * <pre>
 *  Ext.toast({
 *      html: 'Data Saved',
 *      title: 'My Title',
 *      width: 200,
 *      align: 't'
 *  });
 * </pre>
 * <p>This component is derived from the excellent work of a Sencha community member, Eirik
 * Lorentsen.</p>
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html Original Ext JS documentation of 'Ext.window.Toast'
 */
public class Toast extends Window {
  /**
   * @param config @inheritDoc
   */
  public function Toast(config:Toast = null) {
    super();
  }

  [ExtConfig]
  /**
   * Specifies the basic alignment of the toast message with its →<code>anchor</code>. This
   * controls many aspects of the toast animation as well. For fine grain control of
   * the final placement of the toast and its <code>→anchor</code> you may set
   * →<code>anchorAlign</code> as well.
   * <p>Possible values:</p>
   * <ul>
   * <li>br - bottom-right</li>
   * <li>bl - bottom-left</li>
   * <li>tr - top-right</li>
   * <li>tl - top-left</li>
   * <li>t - top</li>
   * <li>l - left</li>
   * <li>b - bottom</li>
   * <li>r - right</li>
   * </ul>
   * @default 't'
   * @see #anchor
   * @see #anchorAlign
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-align Original Ext JS documentation of 'align'
   */
  public native function get align():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set align(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * A flag indicating that this component should be
   * on the top of the z-index stack for use by the →<code>zIndexManager</code> to sort its stack.
   * <p>This may be a positive number to prioritize the ordering of multiple visible
   * always on top components.</p>
   * <p>This may be set to a <i>negative</i> number to prioritize a component to the <i>bottom</i>
   * of the z-index stack.</p>
   * @default true
   * @see #zIndexManager
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-alwaysOnTop Original Ext JS documentation of 'alwaysOnTop'
   * @see #getAlwaysOnTop()
   * @see #setAlwaysOnTop()
   */
  override public native function get alwaysOnTop():*;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set alwaysOnTop(value:*):void;

  [ExtConfig]
  /**
   * The component or the <code>→id</code> of the component to which the <code>toast</code> will be anchored.
   * The default behavior is to anchor a <code>toast</code> to the document body (no component).
   * @default null
   * @see #id
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-anchor Original Ext JS documentation of 'anchor'
   */
  override public native function get anchor():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set anchor(value:String):void;

  [ExtConfig]
  /**
   * This string is a full specification of how to position the toast with respect to
   * its <code>→anchor</code>. This is set to a reasonable value based on <code>→align</code> but the <code>→align</code>
   * also sets defaults for various other properties. This config controls only the
   * final position of the toast.
   * @see #anchor
   * @see #align
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-anchorAlign Original Ext JS documentation of 'anchorAlign'
   */
  public native function get anchorAlign():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set anchorAlign(value:String):void;

  [ExtConfig]
  /**
   * Set this to <code>false</code> to make toasts appear and disappear without animation.
   * This is helpful with applications' unit and integration testing.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-animate Original Ext JS documentation of 'animate'
   */
  public native function get animated():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animated(value:Boolean):void;

  [ExtConfig]
  /**
   * This config ensures that the Toast is closed automatically after a certain amount of time.
   * If this is set to <code>false</code>, closing the Toast will have to be handled some other way
   * (e.g., Setting <code>closable: true</code>).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-autoClose Original Ext JS documentation of 'autoClose'
   */
  public native function get autoClose():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoClose(value:Boolean):void;

  [ExtConfig]
  /**
   * The number of milliseconds a Toast waits before automatically closing.
   * @default 3000
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-autoCloseDelay Original Ext JS documentation of 'autoCloseDelay'
   */
  public native function get autoCloseDelay():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set autoCloseDelay(value:Number):void;

  [ExtConfig]
  /**
   * A shortcut for setting a padding style on the body element. The value can either be
   * a number to be applied to all sides, or a normal css string describing padding.
   * @default 10
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-bodyPadding Original Ext JS documentation of 'bodyPadding'
   */
  override public native function get bodyPadding():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set bodyPadding(value:*):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to display the 'close' tool button and allow the user to close the window, false
   * to hide the button and disallow closing the window.
   * <p>By default, when close is requested by either clicking the close button in the header
   * or pressing ESC when the Window has focus, the →<code>close()</code> method will be called.
   * This will <i>destroy (→<code>ext.Component.destroy()</code>)</i> the Window and its content
   * meaning that it may not be reused.</p>
   * <p>To make closing a Window <i>hide</i> the Window so that it may be reused, set →<code>closeAction</code>
   * to 'hide'.</p>
   * @default false
   * @see #close()
   * @see ext.Component#destroy()
   * @see #closeAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-closable Original Ext JS documentation of 'closable'
   * @see #getClosable()
   * @see #setClosable()
   */
  override public native function get closable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set closable(value:Boolean):void;

  [ExtConfig]
  /**
   * This config will prevent the Toast from closing when a user produces a mousedown event.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-closeOnMouseDown Original Ext JS documentation of 'closeOnMouseDown'
   */
  public native function get closeOnMouseDown():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set closeOnMouseDown(value:Boolean):void;

  [ExtConfig]
  /**
   * An optional extra CSS class that will be added to this component's Element.
   * The value can be a string, a list of strings separated by spaces, or an array of strings.
   * This can be useful for adding customized styles to the component or any of its children
   * using standard CSS rules.
   * @default Ext.baseCSSPrefix + 'toast'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-cls Original Ext JS documentation of 'cls'
   */
  override public native function get cls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set cls(value:String):void;

  [ExtConfig]
  /**
   * True to allow the window to be dragged by the header bar, false to disable dragging.
   * Note that by default the window will be centered in the viewport, so if dragging is disabled
   * the window may need to be positioned programmatically after render (e.g.,
   * <code>myWindow.setPosition(100, 100);</code>).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-draggable Original Ext JS documentation of 'draggable'
   */
  override public native function get draggable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set draggable(value:*):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default false
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  override public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * The number of milliseconds it takes for a Toast to hide.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-hideDuration Original Ext JS documentation of 'hideDuration'
   */
  public native function get hideDuration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideDuration(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its height to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default 1
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-minHeight Original Ext JS documentation of 'minHeight'
   * @see #getMinHeight()
   * @see #setMinHeight()
   */
  override public native function get minHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minHeight(value:Number):void;

  [ExtConfig]
  /**
   * True to render the window body with a transparent background so that it will blend into
   * the framing elements, false to add a lighter background color to visually highlight the body
   * element and separate it more distinctly from the surrounding frame.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  override public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set plain(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to allow user resizing at each edge and corner of the window,
   * false to disable resizing.
   * <p>This may also be specified as a config object to Ext.resizer.Resizer</p>
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-resizable Original Ext JS documentation of 'resizable'
   */
  override public native function get resizable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set resizable(value:*):void;

  [ExtConfig]
  /**
   * Specifies whether the floating component should be given a shadow. Set to true
   * to automatically create an →<code>ext.dom.Shadow</code>, or a string indicating the shadow's display
   * →<code>ext.dom.Shadow.mode</code>. Set to false to disable the shadow.
   * @default false
   * @see ext.dom.Shadow
   * @see ext.dom.Shadow#mode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-shadow Original Ext JS documentation of 'shadow'
   */
  override public native function get shadow():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set shadow(value:*):void;

  [ExtConfig]
  /**
   * The animation used for the Toast to slide back.
   * @default 'bounceOut'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-slideBackAnimation Original Ext JS documentation of 'slideBackAnimation'
   */
  public native function get slideBackAnimation():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set slideBackAnimation(value:String):void;

  [ExtConfig]
  /**
   * The number of milliseconds it takes for a Toast to slide back.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-slideBackDuration Original Ext JS documentation of 'slideBackDuration'
   */
  public native function get slideBackDuration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set slideBackDuration(value:Number):void;

  [ExtConfig]
  /**
   * The animation used for the Toast to slide in.
   * @default 'easeIn'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-slideInAnimation Original Ext JS documentation of 'slideInAnimation'
   */
  public native function get slideInAnimation():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set slideInAnimation(value:String):void;

  [ExtConfig]
  /**
   * The number of milliseconds it takes for a Toast to slide in.
   * @default 500
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-slideInDuration Original Ext JS documentation of 'slideInDuration'
   */
  public native function get slideInDuration():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set slideInDuration(value:Number):void;

  [ExtConfig]
  /**
   * The number of pixels between each Toast notification.
   * @default 6
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-spacing Original Ext JS documentation of 'spacing'
   */
  public native function get spacing():Number;

  [ExtConfig]
  /**
   * @private
   */
  public native function set spacing(value:Number):void;

  [ExtConfig]
  /**
   * This config will prevent the Toast from closing when you click on it. If this is set
   * to <code>true</code>, closing the Toast will have to be handled some other way
   * (e.g., Setting <code>closable: true</code>).
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-stickOnClick Original Ext JS documentation of 'stickOnClick'
   */
  public native function get stickOnClick():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stickOnClick(value:Boolean):void;

  [ExtConfig]
  /**
   * This config will prevent the Toast from closing while you're hovered over it.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-stickWhileHover Original Ext JS documentation of 'stickWhileHover'
   */
  public native function get stickWhileHover():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set stickWhileHover(value:Boolean):void;

  [ExtConfig]
  /**
   * Directs the toast message to animate on the x-axis (if <code>true</code>) or y-axis (if <code>false</code>).
   * This value defaults to a value based on the <code>→align</code> config.
   * @default false
   * @see #align
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Toast.html#cfg-useXAxis Original Ext JS documentation of 'useXAxis'
   */
  public native function get useXAxis():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set useXAxis(value:Boolean):void;

  /**
   * Returns the value of <code>alwaysOnTop</code>.
   * @see #alwaysOnTop
   */
  override public native function getAlwaysOnTop():*;

  /**
   * Returns the value of <code>closable</code>.
   * @see #closable
   */
  override public native function getClosable():Boolean;

  /**
   * Returns the value of <code>minHeight</code>.
   * @see #minHeight
   */
  override public native function getMinHeight():Number;

  /**
   * Sets the value of <code>alwaysOnTop</code>.
   * @param alwaysOnTop The new value.
   * @see #alwaysOnTop
   */
  override public native function setAlwaysOnTop(alwaysOnTop:*):void;

  /**
   * Sets the value of <code>closable</code>.
   * @param closable The new value.
   * @see #closable
   */
  override public native function setClosable(closable:Boolean):void;

  /**
   * Sets the value of <code>minHeight</code>.
   * @param minHeight The new value.
   * @see #minHeight
   */
  override public native function setMinHeight(minHeight:Number):void;
}
}