package ext.window {
import ext.Component;
import ext.dom.Element;
import ext.panel.Panel;
import ext.util.ComponentDragger;

[Native("Ext.window.Window", require)]
/**
 * @see ext.window.events.WindowEvent.ACTIVATE
 * @eventType ext.window.events.WindowEvent.ACTIVATE
 */
[Event(name='onActivate', type='ext.window.events.WindowEvent')]
/**
 * @see ext.window.events.WindowEvent.DEACTIVATE
 * @eventType ext.window.events.WindowEvent.DEACTIVATE
 */
[Event(name='onDeactivate', type='ext.window.events.WindowEvent')]
/**
 * @see ext.window.events.WindowEvent.MASK_CLICK
 * @eventType ext.window.events.WindowEvent.MASK_CLICK
 */
[Event(name='onMaskClick', type='ext.window.events.WindowEvent')]
/**
 * @see ext.window.events.WindowEvent.MAXIMIZE
 * @eventType ext.window.events.WindowEvent.MAXIMIZE
 */
[Event(name='onMaximize', type='ext.window.events.WindowEvent')]
/**
 * @see ext.window.events.WindowEvent.MINIMIZE
 * @eventType ext.window.events.WindowEvent.MINIMIZE
 */
[Event(name='onMinimize', type='ext.window.events.WindowEvent')]
/**
 * @see ext.window.events.Window_width_heightEvent.RESIZE
 * @eventType ext.window.events.Window_width_heightEvent.RESIZE
 */
[Event(name='onResize', type='ext.window.events.Window_width_heightEvent')]
/**
 * @see ext.window.events.WindowEvent.RESTORE
 * @eventType ext.window.events.WindowEvent.RESTORE
 */
[Event(name='onRestore', type='ext.window.events.WindowEvent')]
/**
 * A specialized panel intended for use as an application window. Windows are floated,
 * →<code>resizable</code>, and →<code>draggable</code> by default. Windows can be
 * <i>maximized</i> (→<code>maximizable</code>) to fill the viewport, restored to their prior size, and can be
 * →<code>minimize()</code>d.
 * <p>Windows can also be linked to a →<code>ext.ZIndexManager</code> or managed by the
 * →<code>ext.WindowManager</code> to provide grouping, activation, to front, to back and other
 * application-specific behavior.</p>
 * <p>By default, Windows will be rendered to document.body. To →<code>constrain</code> a Window to another
 * element specify →<code>ext.Component.renderTo</code>.</p>
 * <p><b>As with all →<code>ext.container.Container</code>s, it is important to consider
 * how you want the Window to size and arrange any child Components. Choose an appropriate
 * →<code>layout</code> configuration which lays out child Components in the required manner.</b></p>
 * <p><b>Example:</b></p>
 * <pre>
 * Ext.create('Ext.window.Window', {
 *     title: 'Hello',
 *     height: 200,
 *     width: 400,
 *     layout: 'fit',
 *     items: {  // Let's put an empty grid in just to illustrate fit layout
 *         xtype: 'grid',
 *         border: false,
 *         // One header just for show. There's no data
 *         columns: [{ header: 'World' }],
 *         store: Ext.create('Ext.data.ArrayStore', {}) // A dummy empty data store
 *     }
 * }).show();
 * </pre>
 * @see #resizable
 * @see #draggable
 * @see #maximizable
 * @see #minimize()
 * @see ext.ZIndexManager
 * @see ext.#WindowManager ext.WindowManager
 * @see #constrain
 * @see ext.Component#renderTo
 * @see ext.container.Container
 * @see #layout
 * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html Original Ext JS documentation of 'Ext.window.Window'
 */
public class Window extends Panel {
  /**
   * @param config @inheritDoc
   */
  public function Window(config:Window = null) {
    super();
  }

  [ExtConfig]
  /**
   * By default, when the →<code>ext.Component.alignTo()</code> method is called, a floating
   * component will scroll to keep aligned with the anchoring element if the anchoring element
   * is part of the scroll.
   * <p>If this is not necessary, and the <code>→alignTo()</code> is a one-off operation then set this config
   * to <code>false</code>.</p>
   * @default false
   * @see ext.Component#alignTo()
   * @see #alignTo()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-alignOnScroll Original Ext JS documentation of 'alignOnScroll'
   */
  override public native function get alignOnScroll():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set alignOnScroll(value:Boolean):void;

  [ExtConfig]
  /**
   * Id, Component element, or Component from which the window should animate when
   * shown or hidden.
   * <p>You may also pass true to have the Window animate when maximizing and restoring
   * using the maximize / restore tools created via the →<code>maximizable</code> config.</p>
   * <pre>
   * var btn, win;
   *
   * btn = Ext.create({
   *     xtype: 'button',
   *     renderTo: Ext.getBody(),
   *     text: 'Show Window',
   *     handler: function() {
   *         win.show();
   *     }
   * });
   *
   * win = Ext.create({
   *     xtype: 'window',
   *     title: 'Animate from the Show Window Button',
   *     height: 300,
   *     width: 400,
   *     modal: true,
   *     closeAction: 'hide',
   *     animateTarget: btn
   *     // or btn.getId()
   *     // or btn.getEl()
   *     // or true (when maximizable is true)
   * });
   * </pre>
   * @default null
   * @see #maximizable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-animateTarget Original Ext JS documentation of 'animateTarget'
   */
  public native function get animateTarget():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set animateTarget(value:*):void;

  /**
   * ARIA role for this Component, defaults to no role.
   * With no role, no other ARIA attributes are set.
   * @default 'dialog'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#property-ariaRole Original Ext JS documentation of 'ariaRole'
   */
  override public native function get ariaRole():String;

  /**
   * @private
   */
  override public native function set ariaRole(value:String):void;

  [ExtConfig]
  /**
   * This config is intended mainly for non-→<code>floating</code> Components which may or may not
   * be shown. Instead of using →<code>renderTo</code> in the configuration, and rendering upon
   * construction, this allows a Component to render itself upon first
   * <i>show (→<code>ext.Component.show()</code>)</i>. If →<code>floating</code> is <code>true</code>, the value
   * of this config is omitted as if it is <code>true</code>.
   * <p>Specify as <code>true</code> to have this Component render to the document body upon first show.</p>
   * <p>Specify as an element, or the ID of an element to have this Component render to a specific
   * element upon first show.
   * Windows render to the body on first show.</p>
   * @default true
   * @see #floating
   * @see #renderTo
   * @see ext.Component#show()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-autoRender Original Ext JS documentation of 'autoRender'
   */
  override public native function get autoRender():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set autoRender(value:*):void;

  [ExtConfig]
  /**
   * The base CSS class to apply to this panel's element.
   * @default Ext.baseCSSPrefix + 'window'
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-baseCls Original Ext JS documentation of 'baseCls'
   */
  override public native function get baseCls():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set baseCls(value:String):void;

  [ExtConfig]
  [Bindable]
  /**
   * True to display the 'close' tool button and allow the user to close the window, false
   * to hide the button and disallow closing the window.
   * <p>By default, when close is requested by either clicking the close button in the header
   * or pressing ESC when the Window has focus, the →<code>close()</code> method will be called.
   * This will <i>destroy (→<code>ext.Component.destroy()</code>)</i> the Window and its content
   * meaning that it may not be reused.</p>
   * <p>To make closing a Window <i>hide</i> the Window so that it may be reused, set →<code>closeAction</code>
   * to 'hide'.</p>
   * @default true
   * @see #close()
   * @see ext.Component#destroy()
   * @see #closeAction
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-closable Original Ext JS documentation of 'closable'
   * @see #getClosable()
   * @see #setClosable()
   */
  override public native function get closable():Boolean;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set closable(value:Boolean):void;

  [ExtConfig]
  /**
   * Text to be announced by screen readers when the <b>close</b>
   * <i>tool</i> (→<code>ext.panel.Tool</code>) is focused. Will also be set as the close tool's
   * →<code>ext.panel.Tool.tooltip</code> text.
   * <p><b>Note:</b> Applicable when the panel is →<code>closable</code>: true</p>
   * @default 'Close dialog'
   * @see ext.panel.Tool
   * @see ext.panel.Tool#tooltip
   * @see #closable
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-closeToolText Original Ext JS documentation of 'closeToolText'
   */
  override public native function get closeToolText():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set closeToolText(value:String):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * True to render the window collapsed, false to render it expanded. Note that if
   * →<code>expandOnShow</code> is true (the default) it will override the <code>→collapsed</code> config
   * and the window will always be expanded when shown.
   * @default false
   * @see #expandOnShow
   * @see #collapsed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-collapsed Original Ext JS documentation of 'collapsed'
   * @see #getCollapsed()
   * @see #setCollapsed()
   */
  override public native function get collapsed():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set collapsed(value:Boolean):void;

  [ExtConfig]
  /**
   * True to make the panel collapsible and have an expand/collapse toggle Tool added
   * into the header tool button area. False to keep the panel sized either statically,
   * or by an owning layout manager, with no toggle Tool.
   * When a panel is used in a <i>border layout</i> (→<code>ext.layout.container.BorderLayout</code>), the
   * →<code>floatable</code> option can influence the behavior of collapsing.
   * See →<code>collapseMode</code> and →<code>collapseDirection</code>
   * @default false
   * @see ext.layout.container.BorderLayout
   * @see #floatable
   * @see #collapseMode
   * @see #collapseDirection
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-collapsible Original Ext JS documentation of 'collapsible'
   */
  override public native function get collapsible():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set collapsible(value:Boolean):void;

  [ExtConfig]
  /**
   * True to constrain the window within its containing element, false to allow it to fall outside
   * of its containing element. By default the window will be rendered to <code>document.body</code>.
   * To render and constrain the window within another element specify →<code>renderTo</code>.
   * Optionally the header only can be constrained using →<code>constrainHeader</code>.
   * @default false
   * @see #renderTo
   * @see #constrainHeader
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-constrain Original Ext JS documentation of 'constrain'
   */
  override public native function get constrain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set constrain(value:Boolean):void;

  [ExtConfig]
  /**
   * True to constrain the window header within its containing element (allowing the window body
   * to fall outside of its containing element) or false to allow the header to fall outside
   * its containing element. Optionally the entire window can be constrained using
   * →<code>constrain</code>.
   * @default false
   * @see #constrain
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-constrainHeader Original Ext JS documentation of 'constrainHeader'
   */
  override public native function get constrainHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set constrainHeader(value:Boolean):void;

  /**
   * If this Window is configured →<code>draggable</code>, this property will contain
   * an instance of →<code>ext.util.ComponentDragger</code> (A subclass of
   * →<code>ext.dd.DragTracker</code>) which handles dragging the Window's DOM
   * Element, and constraining according to the →<code>constrain</code> and
   * →<code>constrainHeader</code> .
   * <p>This has implementations of <code>onBeforeStart</code>, <code>onDrag</code> and <code>onEnd</code> which perform
   * the dragging action. If extra logic is needed at these points, use
   * →<code>ext.FunctionUtil.createInterceptor()</code> or
   * →<code>ext.FunctionUtil.createSequence()</code> to augment the existing
   * implementations.</p>
   * @see #draggable
   * @see ext.util.ComponentDragger
   * @see ext.dd.DragTracker
   * @see #constrain
   * @see #constrainHeader
   * @see ext.SFunctionUtil#createInterceptor() ext.FunctionUtil.createInterceptor()
   * @see ext.SFunctionUtil#createSequence() ext.FunctionUtil.createSequence()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#property-dd Original Ext JS documentation of 'dd'
   */
  public native function get dd():ComponentDragger;

  /**
   * @private
   */
  public native function set dd(value:ComponentDragger):void;

  [ExtConfig]
  /**
   * Specifies a Component to receive focus when this Window is focused.
   * <p>If a String is provided, the Component will be resolved using the →<code>down()</code> method
   * which uses →<code>ext.ComponentQuery</code>. If the string begins with an alphanumeric value,
   * it will first attempt to find the Component based on the →<code>ext.Component.id</code> or
   * →<code>ext.Component.itemId</code>. If a matching component is not found via id, then an attempt
   * to do a query to find a matching component.</p>
   * <p>An example of finding the Component with an id/itemId:</p>
   * <pre>
   * Ext.create('Ext.window.Window', {
   *     autoShow     : true,
   *     width        : 300,
   *     title        : 'Login',
   *     defaultFocus : 'username',
   *     items        : [
   *         {
   *             xtype      : 'textfield',
   *             fieldLabel : 'Username',
   *             itemId     : 'username',
   *             name       : 'username'
   *         },
   *         {
   *             xtype      : 'textfield',
   *             inputType  : 'password',
   *             fieldLabel : 'Password',
   *             itemId     : 'password',
   *             name       : 'password'
   *         }
   *     ]
   * });
   * </pre>
   * <p>If a Number is provided, this will resolve an →<code>ext.button.Button</code> at that index.
   * This is very useful if the window has buttons in the →<code>buttons</code> config and you want
   * to provide default focus to one of them.</p>
   * <p>An example of this would be:</p>
   * <pre>
   * Ext.create('Ext.window.Window', {
   *     autoShow     : true,
   *     width        : 300,
   *     title        : 'Login',
   *     defaultFocus : 1,
   *     items        : [
   *         {
   *             xtype      : 'textfield',
   *             fieldLabel : 'Username',
   *             name       : 'username'
   *        },
   *        {
   *             xtype      : 'textfield',
   *             inputType  : 'password',
   *             fieldLabel : 'Password',
   *             name       : 'password'
   *         }
   *     ],
   *     buttons      : [
   *         {
   *             text : 'Cancel'
   *         },
   *         {
   *             text : 'Login'
   *         }
   *     ]
   * });
   * </pre>
   * <p>In summary, defaultFocus may be one of:</p>
   * <ul>
   * <li>The index of a footer Button.</li>
   * <li>The id or →<code>ext.Component.itemId</code> of a descendant Component.</li>
   * <li>A <i>query</i> (→<code>ext.ComponentQuery</code>) to find a →<code>ext.Component</code>.</li>
   * <li>A descendant →<code>ext.Component</code>.</li>
   * </ul>
   * @see #down()
   * @see ext.#ComponentQuery ext.ComponentQuery
   * @see ext.Component#id
   * @see ext.Component#itemId
   * @see ext.button.Button
   * @see #buttons
   * @see ext.Component
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-defaultFocus Original Ext JS documentation of 'defaultFocus'
   */
  override public native function get defaultFocus():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set defaultFocus(value:String):void;

  [ExtConfig]
  /**
   * True to allow the window to be dragged by the header bar, false to disable dragging.
   * Note that by default the window will be centered in the viewport, so if dragging is disabled
   * the window may need to be positioned programmatically after render (e.g.,
   * <code>myWindow.setPosition(100, 100);</code>).
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-draggable Original Ext JS documentation of 'draggable'
   */
  override public native function get draggable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set draggable(value:*):void;

  [ExtConfig]
  /**
   * True to always expand the window when it is displayed, false to keep it in its current state
   * (which may be →<code>collapsed</code>) when displayed.
   * @default true
   * @see #collapsed
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-expandOnShow Original Ext JS documentation of 'expandOnShow'
   */
  public native function get expandOnShow():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set expandOnShow(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as true to float the Component outside of the document flow using CSS absolute
   * positioning.
   * <p>Components such as →<code>ext.window.Window</code>s and →<code>ext.menu.Menu</code>s are
   * floating by default.</p>
   * <p>Floating Components that are programmatically <i>rendered</i> (→<code>ext.Component.render()</code>)
   * will register themselves with the global <i>ZIndexManager</i> (→<code>ext.WindowManager</code>)</p>
   * <p><i>Floating Components as child items of a Container</i></p>
   * <p>A floating Component may be used as a child item of a Container. This just allows
   * the floating Component to seek a ZIndexManager by examining the ownerCt chain.</p>
   * <p>When configured as floating, Components acquire, at render time, a
   * →<code>ext.ZIndexManager</code> which manages a stack of related floating Components.
   * The ZIndexManager sorts its stack according to an incrementing access counter and the
   * →<code>ext.util.Floating.alwaysOnTop</code> config when the Component's
   * →<code>toFront()</code> method is called.</p>
   * <p>The ZIndexManager is found by traversing up the →<code>ownerCt</code> chain to find an ancestor
   * which itself is floating. This is so that descendant floating Components of floating
   * <i>Containers</i> (Such as a ComboBox dropdown within a Window) can have its zIndex managed
   * relative to any siblings, but always <b>above</b> that floating ancestor Container.</p>
   * <p>If no floating ancestor is found, a floating Component registers itself with the default
   * <i>ZIndexManager</i> (→<code>ext.WindowManager</code>).</p>
   * <p>Floating components <i>do not participate in the Container's layout</i>. Because of this,
   * they are not rendered until you explicitly →<code>show()</code> them.</p>
   * <p>After rendering, the ownerCt reference is deleted, and the →<code>floatParent</code> property
   * is set to the found floating ancestor Container. If no floating ancestor Container was found
   * the →<code>floatParent</code> property will not be set.</p>
   * @default true
   * @see ext.window.Window
   * @see ext.menu.Menu
   * @see ext.Component#render()
   * @see ext.#WindowManager ext.WindowManager
   * @see ext.ZIndexManager
   * @see ext.util.Floating#alwaysOnTop
   * @see #toFront()
   * @see #ownerCt
   * @see #show()
   * @see #floatParent
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-floating Original Ext JS documentation of 'floating'
   */
  override public native function get floating():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set floating(value:Boolean):void;

  /**
   * <code>true</code> for keyboard interactive Components or Widgets, <code>false</code> otherwise.
   * For Containers, this property reflects interactiveness of the
   * Container itself, not its children. See →<code>isFocusable()</code>.
   * <p><b>Note:</b> It is not enough to set this property to <code>true</code> to make
   * a component keyboard interactive. You also need to make sure that
   * the component's →<code>focusEl</code> is reachable via Tab key (tabbable).
   * See also →<code>tabIndex</code>.</p>
   * @default true
   * @see #isFocusable()
   * @see #focusEl
   * @see #tabIndex
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#property-focusable Original Ext JS documentation of 'focusable'
   */
  override public native function get focusable():Boolean;

  /**
   * @private
   */
  public native function set focusable(value:Boolean):void;

  [ExtConfig]
  /**
   * Set to false to disable the ghost panel during dragging the window.
   * Do note that you should not set this to true, by default it is a function.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-ghost Original Ext JS documentation of 'ghost'
   */
  public native function get ghost():*;

  [ExtConfig]
  /**
   * @private
   */
  public native function set ghost(value:*):void;

  [ExtConfig]
  /**
   * Render this Window hidden. If <code>true</code>, the →<code>hide()</code> method will be called
   * internally.
   * @default true
   * @see #hide()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-hidden Original Ext JS documentation of 'hidden'
   * @see #setHidden()
   */
  override public native function get hidden():Boolean;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set hidden(value:Boolean):void;

  [ExtConfig]
  /**
   * A String which specifies how this Component's encapsulating DOM element will be hidden.
   * Values may be:
   * <ul>
   * <li><code>'display'</code> : The Component will be hidden using the <code>display: none</code> style.</li>
   * <li><code>'visibility'</code> : The Component will be hidden using the <code>visibility: hidden</code> style.</li>
   * <li><code>'offsets'</code> : The Component will be hidden by absolutely positioning it out of the
   * visible area of the document.
   * This is useful when a hidden Component must maintain measurable dimensions. Hiding using
   * <code>display</code> results in a Component having zero dimensions.
   * Windows hide using offsets in order to preserve the scroll positions of their descendants.
   * You may review other configuration options here: →<code>ext.Component.hideMode</code>.</li>
   * </ul>
   * @default 'offsets'
   * @see ext.Component#hideMode
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-hideMode Original Ext JS documentation of 'hideMode'
   */
  override public native function get hideMode():String;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set hideMode(value:String):void;

  [ExtConfig]
  /**
   * True to hide this Window's shadow when another floating item in the same z-index stack
   * is activated.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-hideShadowOnDeactivate Original Ext JS documentation of 'hideShadowOnDeactivate'
   */
  public native function get hideShadowOnDeactivate():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set hideShadowOnDeactivate(value:Boolean):void;

  /**
   * <code>true</code> in this class to identify an object as an instantiated Window, or subclass thereof.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#property-isWindow Original Ext JS documentation of 'isWindow'
   */
  public native function get isWindow():Boolean;

  /**
   * @private
   */
  public native function set isWindow(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * An object containing handlers for keyboard events. The property names of this
   * object are the key name and any modifiers. The values of the properties are the
   * descriptors of how to handle each event.
   * <p>The handler descriptor can be simply the handler function(either the
   * literal function or the method name), or it can be an object with these
   * properties:</p>
   * <ul>
   * <li><code>handler</code>: The function or its name to call to handle the event.</li>
   * <li><code>scope</code>: The this pointer context (can be "this" or "controller").</li>
   * <li><code>event</code>: An optional override of the key event to which to listen.</li>
   * </ul>
   * <p><b>Important:</b> Calls to <code>setKeyMap</code> do not replace the entire <code>→keyMap</code> but
   * instead update the provided mappings. That is, unless <code>null</code> is passed as the
   * value of the <code>→keyMap</code> which will clear the <code>→keyMap</code> of all entries.</p>
   * @default {
   *     scope: 'this',
   *     ESC: 'onEsc'
   * }
   * @see #keyMap
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-keyMap Original Ext JS documentation of 'keyMap'
   * @see #getKeyMap()
   * @see #setKeyMap()
   */
  override public native function get keyMap():Object;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set keyMap(value:Object):void;

  [ExtConfig]
  /**
   * The method to call when the window's modal mask is clicked or tapped...
   * <ul>
   * <li>
   * <p><b><code>'→focus()'</code></b> :</p>
   * <p>The default. Focus the window, which will then pass focus into its
   * →<code>defaultFocus</code> delegate.</p>
   * </li>
   * <li>
   * <p><b><code>'→destroy()'</code></b> :</p>
   * <p>Remove the window from the DOM and →<code>ext.Component.destroy()</code>
   * it and all descendant Components. The window will <b>not</b> be available to be redisplayed
   * via the →<code>show()</code> method.</p>
   * </li>
   * <li>
   * <p><b><code>'→hide()'</code></b> :</p>
   * <p>→<code>hide()</code> the window by setting visibility to hidden and applying negative
   * offsets. The window will be available to be redisplayed via the →<code>show()</code>
   * method.</p>
   * </li>
   * </ul>
   * @default 'focus'
   * @since 6.2.0
   * @see #focus()
   * @see #defaultFocus
   * @see #destroy()
   * @see ext.Component#destroy()
   * @see #show()
   * @see #hide()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-maskClickAction Original Ext JS documentation of 'maskClickAction'
   */
  public native function get maskClickAction():String;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maskClickAction(value:String):void;

  [ExtConfig]
  /**
   * True to display the 'maximize' tool button and allow the user to maximize the window,
   * false to hide the button and disallow maximizing the window. Note that when a window
   * is maximized, the tool button will automatically change to a 'restore' button with
   * the appropriate behavior already built-in that will restore the window to its previous size.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-maximizable Original Ext JS documentation of 'maximizable'
   */
  public native function get maximizable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maximizable(value:Boolean):void;

  [ExtConfig]
  /**
   * True to initially display the window in a maximized state.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-maximized Original Ext JS documentation of 'maximized'
   */
  public native function get maximized():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set maximized(value:Boolean):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its height to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default 50
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-minHeight Original Ext JS documentation of 'minHeight'
   * @see #getMinHeight()
   * @see #setMinHeight()
   */
  override public native function get minHeight():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minHeight(value:Number):void;

  [ExtConfig]
  [Bindable]
  /**
   * The minimum value in pixels which this Component will set its width to.
   * <p><b>Warning:</b> This will override any size management applied by layout managers.</p>
   * @default 50
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-minWidth Original Ext JS documentation of 'minWidth'
   * @see #getMinWidth()
   * @see #setMinWidth()
   */
  override public native function get minWidth():Number;

  [ExtConfig]
  [Bindable]
  /**
   * @private
   */
  override public native function set minWidth(value:Number):void;

  [ExtConfig]
  /**
   * True to display the 'minimize' tool button and allow the user to minimize the window,
   * false to hide the button and disallow minimizing the window. Note that this button provides
   * no implementation -- the behavior of minimizing a window is implementation-specific,
   * so the minimize event must be handled and a custom minimize behavior implemented
   * for this option to be useful.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-minimizable Original Ext JS documentation of 'minimizable'
   */
  public native function get minimizable():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set minimizable(value:Boolean):void;

  [ExtConfig]
  /**
   * <code>true</code> to listen to the viewport resize event and perform any layout updating if necessary.
   * This is useful if using sizes as percentages for the window.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-monitorResize Original Ext JS documentation of 'monitorResize'
   */
  public native function get monitorResize():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set monitorResize(value:Boolean):void;

  [ExtConfig]
  /**
   * Allows override of the built-in processing for the escape key. Default action is to close
   * the Window (performing whatever action is specified in →<code>closeAction</code>. To prevent
   * the Window closing when the escape key is pressed, specify this as
   * →<code>ext.Ext.emptyFn</code>.
   * @see #closeAction
   * @see ext.SExt#emptyFn ext.Ext.emptyFn
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-onEsc Original Ext JS documentation of 'onEsc'
   */
  public native function get onEsc():Function;

  [ExtConfig]
  /**
   * @private
   */
  public native function set onEsc(value:Function):void;

  [ExtConfig]
  /**
   * True to overlap the header in a panel over the framing of the panel itself. This is needed
   * when <code>frame: true</code> (and is done automatically for you). Otherwise it is undefined.
   * If you manually add rounded corners to a panel header which does not have <code>frame: true</code>,
   * this will need to be set to true.
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-overlapHeader Original Ext JS documentation of 'overlapHeader'
   */
  override public native function get overlapHeader():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set overlapHeader(value:Boolean):void;

  [ExtConfig]
  /**
   * True to render the window body with a transparent background so that it will blend into
   * the framing elements, false to add a lighter background color to visually highlight the body
   * element and separate it more distinctly from the surrounding frame.
   * @default false
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-plain Original Ext JS documentation of 'plain'
   */
  public native function get plain():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  public native function set plain(value:Boolean):void;

  [ExtConfig]
  /**
   * Specify as <code>true</code> to allow user resizing at each edge and corner of the window,
   * false to disable resizing.
   * <p>This may also be specified as a config object to Ext.resizer.Resizer</p>
   * @default true
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-resizable Original Ext JS documentation of 'resizable'
   */
  override public native function get resizable():*;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set resizable(value:*):void;

  [ExtConfig]
  /**
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-simpleDrag Original Ext JS documentation of 'simpleDrag'
   */
  override public native function get simpleDrag():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set simpleDrag(value:Boolean):void;

  [ArrayElementType("String")]
  [ExtConfig]
  /**
   * An array of events that, when fired, should trigger this object to
   * save its state. <code>→stateEvents</code> defaults to the <code>→stateEvents</code> associated with the
   * component you are using. Any events you statically set will be appended to that list.
   * <code>→stateEvents</code> may be any type of event supported by this object, including
   * browser or custom events (e.g., <code>['click', 'customerchange']</code>).
   * <p>See <code>→stateful</code> for an explanation of saving and
   * restoring object state.
   * By default the following stateEvents are added:</p>
   * <ul>
   * <li>→<code>event:onResize</code> - <i>(added by Ext.Component)</i></li>
   * <li>→<code>event:onCollapse</code> - <i>(added by Ext.panel.Panel)</i></li>
   * <li>→<code>event:onExpand</code> - <i>(added by Ext.panel.Panel)</i></li>
   * <li>→<code>event:onMaximize</code></li>
   * <li>→<code>event:onRestore</code></li>
   * <li>→<code>event:onResize</code></li>
   * <li>→<code>event:onDragEnd</code></li>
   * </ul>
   * @see #stateEvents
   * @see #stateful
   * @see #event:onResize
   * @see #event:onCollapse
   * @see #event:onExpand
   * @see #event:onMaximize
   * @see #event:onRestore
   * @see #event:onDragEnd
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-stateEvents Original Ext JS documentation of 'stateEvents'
   */
  override public native function get stateEvents():Array;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set stateEvents(value:Array):void;

  [ExtConfig]
  /**
   * When set to <code>true</code>, two elements are added to the container's element. These are the
   * <code>→tabGuardBeforeEl</code> and <code>→tabGuardAfterEl</code>.
   * @default true
   * @see #tabGuardBeforeEl
   * @see #tabGuardAfterEl
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-tabGuard Original Ext JS documentation of 'tabGuard'
   */
  override public native function get tabGuard():Boolean;

  [ExtConfig]
  /**
   * @private
   */
  override public native function set tabGuard(value:Boolean):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The X position of the left edge of the window on initial showing. Defaults to centering
   * the Window within the width of the Window's container →<code>ext.dom.Element</code>
   * (The Element that the Window is rendered to).
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-x Original Ext JS documentation of 'x'
   * @see #getX()
   * @see #setX()
   */
  override public native function get x():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set x(value:Number):void;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * The Y position of the top edge of the window on initial showing. Defaults to centering
   * the Window within the height of the Window's container →<code>ext.dom.Element</code>
   * (The Element that the Window is rendered to).
   * @see ext.dom.Element
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#cfg-y Original Ext JS documentation of 'y'
   * @see #getY()
   * @see #setY()
   */
  override public native function get y():Number;

  [ExtConfig]
  [Bindable(style="methods")]
  /**
   * @private
   */
  override public native function set y(value:Number):void;

  /**
   * Returns the value of <code>closable</code>.
   * @see #closable
   */
  override public native function getClosable():Boolean;

  /**
   * Gets the configured default focus item. If a →<code>defaultFocus</code> is set, it will
   * receive focus when the Window's <code>focus</code> method is called, otherwise the
   * Window itself will receive focus.
   * @see #defaultFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-getDefaultFocus Original Ext JS documentation of 'getDefaultFocus'
   */
  override public native function getDefaultFocus():Component;

  /**
   * Returns the focus holder element associated with this Window.
   * By default, this is the Window's element; this can be overridden
   * by setting →<code>defaultFocus</code> property.
   * @return the focus holding element or Component.
   * @see #defaultFocus
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-getFocusEl Original Ext JS documentation of 'getFocusEl'
   */
  override protected native function getFocusEl():Element;

  /**
   * Returns the value of <code>keyMap</code>.
   * @see #keyMap
   */
  override public native function getKeyMap():Object;

  /**
   * Returns the value of <code>minHeight</code>.
   * @see #minHeight
   */
  override public native function getMinHeight():Number;

  /**
   * Returns the value of <code>minWidth</code>.
   * @see #minWidth
   */
  override public native function getMinWidth():Number;

  /**
   * Fits the window within its current container and automatically replaces the
   * <i>'maximize' tool button</i> (→<code>maximizable</code>) with the 'restore' tool button.
   * Also see →<code>toggleMaximize()</code>.
   * @param animate Pass <code>true</code> to animate this Window to full size.
   * @default false
   * @return this
   * @see #maximizable
   * @see #toggleMaximize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-maximize Original Ext JS documentation of 'maximize'
   */
  public native function maximize(animate:Boolean = false):Window;

  /**
   * Placeholder method for minimizing the window. By default, this method simply fires the
   * →<code>event:onMinimize</code> event since the behavior of minimizing a window
   * is application-specific. To implement custom minimize behavior, either the minimize event
   * can be handled or this method can be overridden.
   * @return this
   * @see #event:onMinimize
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-minimize Original Ext JS documentation of 'minimize'
   */
  public native function minimize():Window;

  /**
   * Restores a <i>maximized</i> (→<code>maximizable</code>) window back to its original size and position
   * prior to being maximized and also replaces the 'restore' tool button with the 'maximize'
   * tool button. Also see →<code>toggleMaximize()</code>.
   * @param animate Pass <code>true</code> to animate the restore.
   * @default false
   * @return this
   * @see #maximizable
   * @see #toggleMaximize()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-restore Original Ext JS documentation of 'restore'
   */
  public native function restore(animate:Boolean = false):Window;

  /**
   * Sets the value of <code>closable</code>.
   * @param closable The new value.
   * @see #closable
   */
  override public native function setClosable(closable:Boolean):void;

  /**
   * Sets the value of <code>keyMap</code>.
   * @param keyMap The new value.
   * @see #keyMap
   */
  override public native function setKeyMap(keyMap:Object):void;

  /**
   * Sets the value of <code>minHeight</code>.
   * @param minHeight The new value.
   * @see #minHeight
   */
  override public native function setMinHeight(minHeight:Number):void;

  /**
   * Sets the value of <code>minWidth</code>.
   * @param minWidth The new value.
   * @see #minWidth
   */
  override public native function setMinWidth(minWidth:Number):void;

  /**
   * A shortcut method for toggling between →<code>maximize()</code> and →<code>restore()</code>
   * based on the current maximized state of the window.
   * @return this
   * @see #maximize()
   * @see #restore()
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#method-toggleMaximize Original Ext JS documentation of 'toggleMaximize'
   */
  public native function toggleMaximize():Window;
}
}