package ext.window.events {
import ext.window.Window;

import net.jangaroo.ext.FlExtEvent;

[Rename("Ext.window.events.Window_width_heightEvent")]
public class Window_width_heightEvent extends FlExtEvent {
  /**
   * Fires after the window has been resized.
   * @see https://docs.sencha.com/extjs/7.2.0/classic/Ext.window.Window.html#event-resize Original Ext JS documentation of 'resize'
   * @see ext.window.Window
   * @eventType onResize
   */
  public static const RESIZE:String = "onResize";
  public static const __PARAMETER_SEQUENCE__:Array = ["source", "width", "height", "eOpts"];

  public function Window_width_heightEvent(type:String, arguments:Array) {
    super(type, arguments);
  }

  /**
   * The window's new height
   */
  public native function get height():Number;

  public native function get source():Window;

  /**
   * The window's new width
   */
  public native function get width():Number;
}
}