/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.file;

import java.io.File;
import java.io.IOException;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.extxml.model.ComponentType;
import net.jangaroo.extxml.xml.ContentHandlerUtils;
import net.jangaroo.extxml.xml.ExmlToComponentMetadataHandler;
import org.codehaus.plexus.util.FileUtils;

public class ExmlComponentSrcFileScanner {
    public static final String EXML_NAMESPACE_URI = "http://net.jangaroo.com/extxml/0.1";

    private ExmlComponentSrcFileScanner() {
    }

    public static void scan(ComponentSuite componentSuite, File srcFile, ComponentType type) throws IOException {
        assert (ComponentType.EXML.equals((Object)type));
        ComponentClass clazz = new ComponentClass(srcFile);
        clazz.setSuite(componentSuite);
        String fullName = ExmlComponentSrcFileScanner.getComponentClassName(componentSuite, srcFile);
        clazz.setFullClassName(fullName);
        clazz.setXtype(fullName);
        clazz.setType(ComponentType.EXML);
        ExmlToComponentMetadataHandler metadataHandler = new ExmlToComponentMetadataHandler();
        if (ContentHandlerUtils.parseExmlWithHandler(clazz, metadataHandler)) {
            clazz.setSuperClassLocalName(metadataHandler.getSuperClassLocalName());
            clazz.setSuperClassNamespaceUri(metadataHandler.getSuperClassUri());
            clazz.setDescription(metadataHandler.getComponentDescription());
            clazz.setCfgs(metadataHandler.getCfgs());
        }
        componentSuite.addComponentClass(clazz);
    }

    public static String getComponentClassName(ComponentSuite componentSuite, File srcFile) {
        String className = FileUtils.removeExtension((String)srcFile.getName());
        String packageName = FileUtils.dirname((String)ComponentClass.relativeSrcFilePath(componentSuite, srcFile).substring(1)).replaceAll("[\\\\/]", ".");
        String fullName = packageName != null && !"".equals(packageName) ? packageName + "." + className : className;
        return fullName;
    }
}

