/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.generation;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.extxml.model.ComponentType;
import net.jangaroo.extxml.xml.ContentHandlerUtils;
import net.jangaroo.extxml.xml.ExmlToJsonHandler;
import net.jangaroo.utils.log.Log;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;
import org.apache.maven.shared.model.fileset.mappers.GlobPatternMapper;
import org.codehaus.plexus.util.StringUtils;

public final class JooClassGenerator {
    private static final FileNameMapper XML_TO_JS_MAPPER = new GlobPatternMapper();
    private static final String outputCharset = "UTF-8";
    private ComponentSuite componentSuite;

    public JooClassGenerator(ComponentSuite componentSuite) {
        this.componentSuite = componentSuite;
    }

    public void generateJangarooClass(ComponentClass jooClass, Writer output) throws IOException, TemplateException {
        if (this.validateComponentClass(jooClass)) {
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(ComponentClass.class, "/");
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            if (jooClass.getJson() != null) {
                cfg.setSharedVariable("jsonForTemplate", (Object)jooClass.getJson().toString(2, 4));
            }
            Template template = cfg.getTemplate("/net/jangaroo/extxml/templates/jangaroo_class.ftl");
            Environment env = template.createProcessingEnvironment((Object)jooClass, output);
            env.setOutputEncoding(outputCharset);
            env.process();
        }
    }

    private boolean validateComponentClass(ComponentClass jooClass) {
        boolean isValid = true;
        if (StringUtils.isEmpty((String)jooClass.getXtype())) {
            Log.e((String)String.format("Xtype of component '%s' is undefined!", jooClass.getFullClassName()));
            isValid = false;
        }
        if (StringUtils.isEmpty((String)jooClass.getClassName())) {
            Log.e((String)String.format("Class name of component '%s' is undefined!", jooClass.getFullClassName()));
            isValid = false;
        }
        if (StringUtils.isEmpty((String)jooClass.getSuperClassName())) {
            Log.e((String)String.format("Super class of component '%s' is undefined!", jooClass.getFullClassName()));
            isValid = false;
        }
        for (String importStr : jooClass.getImports()) {
            if (!StringUtils.isEmpty((String)importStr)) continue;
            Log.e((String)String.format("An empty import found. Something is wrong in your class %s", jooClass.getFullClassName()));
            isValid = false;
        }
        return isValid;
    }

    public void generateClasses() {
        for (ComponentClass cc : this.componentSuite.getComponentClassesByType(ComponentType.EXML)) {
            this.generateClass(cc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateClass(ComponentClass componentClass) {
        ExmlToJsonHandler handler = new ExmlToJsonHandler(this.componentSuite);
        if (ContentHandlerUtils.parseExmlWithHandler(componentClass, handler)) {
            componentClass.setImports(handler.getImports());
            componentClass.setJson(handler.getJson());
            File outputFile = new File(this.componentSuite.getAs3OutputDir(), XML_TO_JS_MAPPER.mapFileName(componentClass.getRelativeSrcFilePath()));
            if (!outputFile.getParentFile().exists() && outputFile.getParentFile().mkdirs()) {
                Log.d((String)("Created parent output folder for " + outputFile.getAbsolutePath()));
            }
            Writer writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputCharset);
                this.generateJangarooClass(componentClass, writer);
            }
            catch (IOException e) {
                Log.e((String)"Exception while creating class", (Exception)e);
            }
            catch (TemplateException e) {
                Log.e((String)"Exception while creating class", (Exception)((Object)e));
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {}
            }
            return outputFile;
        }
        return null;
    }

    static {
        XML_TO_JS_MAPPER.setFrom("*." + ComponentType.EXML.getExtension());
        XML_TO_JS_MAPPER.setTo("*." + ComponentType.ActionScript.getExtension());
    }
}

