/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.generation;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import net.jangaroo.extxml.model.ComponentSuite;
import net.jangaroo.utils.log.Log;

public final class XsdGenerator {
    private static final String outputCharset = "UTF-8";
    private static Configuration cfg = new Configuration();
    private ComponentSuite componentSuite;

    public XsdGenerator(ComponentSuite componentSuite) {
        this.componentSuite = componentSuite;
    }

    public void generateXsd(Writer out) throws IOException {
        if (!this.componentSuite.getComponentClasses().isEmpty()) {
            Template template = null;
            try {
                template = cfg.getTemplate("component-suite-xsd.ftl");
            }
            catch (IOException e) {
                Log.e((String)"Could not read xsd template", (Exception)e);
            }
            if (template != null) {
                Log.i((String)String.format("Writing XML Schema '%s' ", this.componentSuite.getNamespace()));
                try {
                    Environment env = template.createProcessingEnvironment((Object)this.componentSuite, out);
                    env.setOutputEncoding(outputCharset);
                    env.process();
                }
                catch (TemplateException e) {
                    Log.e((String)"Error while generating xsd", (Exception)((Object)e));
                }
            }
        }
    }

    static {
        cfg.setClassForTemplateLoading(XsdGenerator.class, "/net/jangaroo/extxml/templates");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setOutputEncoding(outputCharset);
    }
}

