/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.json;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jangaroo.extxml.ComponentSuiteRegistry;
import net.jangaroo.extxml.json.Json;
import net.jangaroo.extxml.json.JsonArray;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.utils.log.Log;

public class JsonObject
implements Json {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private String typePropertyName;

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public void setTypePropertyName(String typePropertyName) {
        this.typePropertyName = typePropertyName;
    }

    public String getType() {
        return (String)this.get(this.getTypePropertyName());
    }

    public void setType(String type) {
        this.set(this.getTypePropertyName(), type);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static String valueToString(String key, Object value, int indentFactor, int indent) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)value;
            return jsonObject.toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        if ("xtype".equals(key) || "ptype".equals(key) || "type".equals(key)) {
            ComponentClass compClazz;
            String xtype = (String)value;
            if ("type".equals(key) && xtype.endsWith("layout")) {
                xtype = xtype.substring(0, xtype.length() - "layout".length());
            }
            if ((compClazz = ComponentSuiteRegistry.getInstance().findComponentClassByXtype(xtype)) != null && !compClazz.getFullClassName().startsWith("ext.")) {
                return compClazz.getFullClassName() + "." + key;
            }
            return "\"" + xtype + "\"";
        }
        if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
            return ((String)value).substring(1, ((String)value).lastIndexOf("}"));
        }
        return JsonObject.quote(value.toString());
    }

    @Override
    public String toString(int indentFactor, int indent) {
        Set<String> keySet = this.properties.keySet();
        ComponentClass actionClass = null;
        Object atype = this.get("atype");
        if (atype instanceof String) {
            actionClass = ComponentSuiteRegistry.getInstance().findComponentClassByXtype((String)atype);
            if (actionClass == null) {
                Log.e((String)("No Action found for atype '" + atype + "'."));
            } else {
                keySet = new LinkedHashSet<String>(keySet);
                keySet.remove("atype");
            }
        }
        StringBuilder sb = new StringBuilder("{");
        int newindent = indent + indentFactor;
        int n = keySet.size();
        Iterator<String> keys = keySet.iterator();
        if (n == 1) {
            this.writeKeyValue(keys.next(), indentFactor, indent, sb);
        } else if (n > 1) {
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                this.newlineAndIndent(sb, newindent);
                this.writeKeyValue(keys.next(), indentFactor, newindent, sb);
            }
            if (sb.length() > 1) {
                this.newlineAndIndent(sb, indent);
            }
        }
        sb.append('}');
        return actionClass == null ? sb.toString() : String.format("new %s(%s)", actionClass.getFullClassName(), sb.toString());
    }

    private void newlineAndIndent(StringBuilder sb, int indent) {
        sb.append('\n');
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    private void writeKeyValue(String key, int indentFactor, int indent, StringBuilder sb) {
        sb.append(key);
        sb.append(": ");
        sb.append(JsonObject.valueToString(key, this.properties.get(key), indentFactor, indent));
    }

    @Override
    public Object get(String property) {
        return this.properties.get(property);
    }

    @Override
    public void set(String property, Object value) {
        this.properties.put(property, value);
    }

    public Object remove(String property) {
        return this.properties.remove(property);
    }
}

