/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.extxml.ComponentSuiteRegistry;
import net.jangaroo.extxml.model.ComponentClass;
import net.jangaroo.extxml.model.ComponentType;
import net.jangaroo.utils.log.Log;

public final class ComponentSuite {
    private String ns;
    private String namespace;
    private File rootDir;
    private File as3OutputDir;
    private Map<String, ComponentClass> componentClassesByXtype = new HashMap<String, ComponentClass>();
    private Map<String, ComponentClass> componentClassesByLocalName = new HashMap<String, ComponentClass>();
    private Map<String, ComponentClass> componentClassesByFullClassName = new HashMap<String, ComponentClass>();
    private Map<String, ComponentSuite> usedComponentSuites;
    private static final Comparator<ComponentClass> COMPONENT_CLASS_BY_ELEMENT_NAME_COMPARATOR = new Comparator<ComponentClass>(){

        @Override
        public int compare(ComponentClass cc1, ComponentClass cc2) {
            return cc1.getElementName().compareTo(cc2.getElementName());
        }
    };

    public ComponentSuite() {
        this(null, null, null, null);
    }

    public ComponentSuite(String namespace, String namespacePrefix, File rootDir, File as3OutputDir) {
        this.namespace = namespace;
        this.ns = namespacePrefix;
        this.rootDir = rootDir;
        this.as3OutputDir = as3OutputDir;
        ComponentSuiteRegistry.getInstance().add(this);
        this.usedComponentSuites = new LinkedHashMap<String, ComponentSuite>();
    }

    public void addImportedComponentSuite(ComponentSuite importedSuite) {
        if (importedSuite != null) {
            ComponentSuiteRegistry.getInstance().add(importedSuite);
        }
    }

    public Map<String, ComponentSuite> getUsedComponentSuitesByNs() {
        return this.usedComponentSuites;
    }

    public Collection<ComponentSuite> getUsedComponentSuites() {
        return this.usedComponentSuites.values();
    }

    public String getUsedComponentSuiteNamespaces() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ComponentSuite> usedComponentSuiteEntry : this.usedComponentSuites.entrySet()) {
            builder.append(" xmlns:").append(usedComponentSuiteEntry.getKey()).append("='").append(usedComponentSuiteEntry.getValue().getNamespace()).append("'");
        }
        return builder.toString();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNs(String ns) {
        this.ns = ns;
    }

    public String getNs() {
        return this.ns == null ? "" : this.ns;
    }

    public String getPrefix() {
        return this.ns == null || this.ns.length() == 0 ? "" : this.ns + ":";
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setAs3OutputDir(File as3OutputDir) {
        this.as3OutputDir = as3OutputDir;
    }

    public File getAs3OutputDir() {
        return this.as3OutputDir;
    }

    public void addComponentClass(ComponentClass cc) {
        cc.setSuite(this);
        this.componentClassesByXtype.put(cc.getXtype(), cc);
        this.componentClassesByLocalName.put(cc.getElementName(), cc);
        this.componentClassesByFullClassName.put(cc.getFullClassName(), cc);
    }

    public List<ComponentClass> getSortedComponentClasses() {
        ArrayList<ComponentClass> components = new ArrayList<ComponentClass>(this.getComponentClasses());
        Collections.sort(components, COMPONENT_CLASS_BY_ELEMENT_NAME_COMPARATOR);
        return components;
    }

    public Collection<ComponentClass> getComponentClasses() {
        return this.componentClassesByXtype.values();
    }

    public ComponentClass getComponentClassByXtype(String xtype) {
        return this.componentClassesByXtype.get(xtype);
    }

    public ComponentClass getComponentClassByLocalName(String localName) {
        return this.componentClassesByLocalName.get(localName);
    }

    public ComponentClass getComponentClassByNamespaceAndLocalName(String namespaceUri, String localName) {
        ComponentClass componentClass = ComponentSuiteRegistry.getInstance().getComponentClass(namespaceUri, localName);
        this.updateUsedComponentSuites(componentClass);
        return componentClass;
    }

    public ComponentClass findComponentClassByXtype(String xtype) {
        ComponentClass componentClass = ComponentSuiteRegistry.getInstance().findComponentClassByXtype(xtype);
        this.updateUsedComponentSuites(componentClass);
        return componentClass;
    }

    public ComponentClass getComponentClassByFullClassName(String className) {
        return this.componentClassesByFullClassName.get(className);
    }

    public ComponentClass findComponentClassByFullClassName(String className) {
        ComponentClass componentClass = ComponentSuiteRegistry.getInstance().findComponentClassByFullClassName(className);
        this.updateUsedComponentSuites(componentClass);
        return componentClass;
    }

    public List<ComponentClass> getComponentClassesByType(ComponentType type) {
        ArrayList<ComponentClass> result = new ArrayList<ComponentClass>();
        for (ComponentClass clazz : this.componentClassesByXtype.values()) {
            if (!type.equals((Object)clazz.getType())) continue;
            result.add(clazz);
        }
        return result;
    }

    private void updateUsedComponentSuites(ComponentClass componentClass) {
        if (componentClass == null) {
            return;
        }
        ComponentSuite importedComponentSuite = componentClass.getSuite();
        if (importedComponentSuite != this && !this.usedComponentSuites.containsValue(importedComponentSuite)) {
            String suiteNs = importedComponentSuite.getNs();
            if (suiteNs == null || suiteNs.length() == 0 || this.usedComponentSuites.containsKey(suiteNs)) {
                int index = 1;
                while (this.usedComponentSuites.containsKey(suiteNs = "cs" + index)) {
                    ++index;
                }
                importedComponentSuite.setNs(suiteNs);
            }
            this.usedComponentSuites.put(suiteNs, importedComponentSuite);
        }
    }

    public void resolveSuperClasses() {
        for (ComponentClass cc : this.getComponentClasses()) {
            if (cc.getSuperClass() == null && cc.getSuperClassName() != null) {
                Log.w((String)("Super component class '" + cc.getSuperClassName() + "' not found."));
                continue;
            }
            if (cc.getSuperClassName() != null || cc.getSuperClassNamespaceUri() == null || cc.getSuperClassLocalName() == null) continue;
            ComponentClass supercl = this.getComponentClassByNamespaceAndLocalName(cc.getSuperClassNamespaceUri(), cc.getSuperClassLocalName());
            if (supercl != null) {
                cc.setSuperClassName(supercl.getFullClassName());
                continue;
            }
            Log.e((String)String.format("Super component class with element name '%s' not found in component suite '%s'", cc.getSuperClassLocalName(), cc.getSuperClassNamespaceUri()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("namespace: ").append(this.namespace).append("\n").append("src root:  ").append(this.rootDir).append("\n\n");
        for (ComponentClass cc : this.getComponentClasses()) {
            builder.append(cc).append("\n\n");
        }
        return builder.toString();
    }
}

