/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.extxml.xml;

import java.util.ArrayList;
import java.util.List;
import net.jangaroo.extxml.model.ConfigAttribute;
import net.jangaroo.extxml.xml.CharacterRecordingHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExmlToComponentMetadataHandler
extends CharacterRecordingHandler {
    private String componentDescription = "";
    private List<ConfigAttribute> cfgs = new ArrayList<ConfigAttribute>();
    private String superClassLocalName;
    private String superClassNamespaceUri;
    private boolean expectsOptionalConfigDescription = false;
    private boolean expectsOptionalComponentDescription = false;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://net.jangaroo.com/extxml/0.1".equals(uri)) {
            if ("component".equals(localName)) {
                this.expectsOptionalComponentDescription = true;
            } else if ("cfg".equals(localName)) {
                this.cfgs.add(new ConfigAttribute(atts.getValue("name"), atts.getValue("type")));
                this.expectsOptionalConfigDescription = true;
            } else if ("description".equals(localName) && (this.expectsOptionalConfigDescription || this.expectsOptionalComponentDescription)) {
                this.startRecordingCharacters();
            }
        } else if (this.superClassLocalName == null && this.superClassNamespaceUri == null) {
            this.superClassLocalName = localName;
            this.superClassNamespaceUri = uri;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String characters;
        if ("http://net.jangaroo.com/extxml/0.1".equals(uri) && "description".equals(localName) && (characters = this.popRecordedCharacters()) != null) {
            if (this.expectsOptionalConfigDescription) {
                this.cfgs.get(this.cfgs.size() - 1).setDescription(characters.trim());
                this.expectsOptionalConfigDescription = false;
            } else if (this.expectsOptionalComponentDescription) {
                this.componentDescription = characters.trim();
                this.expectsOptionalComponentDescription = false;
            }
        }
    }

    public String getSuperClassLocalName() {
        return this.superClassLocalName;
    }

    public String getSuperClassUri() {
        return this.superClassNamespaceUri;
    }

    public List<ConfigAttribute> getCfgs() {
        return this.cfgs;
    }

    public String getComponentDescription() {
        return this.componentDescription;
    }
}

