/*
 * JetS3t : Java S3 Toolkit
 * Project hosted at http://bitbucket.org/jmurty/jets3t/
 *
 * Copyright 2006-2010 James Murty
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jets3t.service.model;

import org.jets3t.service.Constants;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import com.jamesmurty.utils.XMLBuilder;

/**
 * Represents Bucket Logging Status settings used to control bucket-based Server Access Logging in
 * Google Storage.
 * <p>
 * For logging to be enabled for a bucket both the targetBucketName and logfilePrefix must be
 * non-null, and the named bucket must exist. When both variables are non-null, this object
 * represents an <b>enabled</b> logging status (as indicated by {@link #isLoggingEnabled()}) and
 * the XML document generated by {@link #toXml()} will enable logging for the named bucket when
 * provided to {@link GoogleStorageService#setBucketLoggingStatus(String, GSBucketLoggingStatus)}
 * <p>
 * If either the targetBucketName or logfilePrefix are null, this object will represent a
 * <b>disabled</b> logging status (as indicated by {@link #isLoggingEnabled()}) and
 * the XML document generated by {@link #toXml()} will disable logging for the named bucket when
 * provided to {@link GoogleStorageService#setBucketLoggingStatus(String, GSBucketLoggingStatus)}.
 *
 * @author James Murty
 */
public class GSBucketLoggingStatus extends StorageBucketLoggingStatus {
    private GSAccessControlList predefinedAcl;

    public GSBucketLoggingStatus() {
        super();
    }

    public GSBucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        super(targetBucketName, logfilePrefix);
    }

    public void setPredefinedAcl(GSAccessControlList predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
    }

    @Override
    public XMLBuilder toXMLBuilder() throws ParserConfigurationException,
            FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create("Logging")
                .attr("xmlns", Constants.XML_NAMESPACE);

        if(isLoggingEnabled()) {
            builder.elem("LogBucket").text(getTargetBucketName()).up();
            builder.elem("LogObjectPrefix").text(getLogfilePrefix()).up();
            if(predefinedAcl != null) {
                builder.elem("PredefinedAcl").text(predefinedAcl.getValueForRESTHeaderACL()).up();
            }
        }
        return builder;
    }
}
