/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.mocksgs;

import com.sun.sgs.app.Channel;
import com.sun.sgs.app.ChannelListener;
import com.sun.sgs.app.ClientSession;
import com.sun.sgs.app.Delivery;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MockChannel
implements Channel {
    private final String name;
    private final ChannelListener listener;
    private final Delivery delivery;
    private final Map<ClientSession, ChannelListener> clientSessions = new HashMap<ClientSession, ChannelListener>();

    public MockChannel(String name, ChannelListener listener, Delivery delivery) {
        this.name = name;
        this.listener = listener;
        this.delivery = delivery;
    }

    public void close() {
    }

    public Delivery getDeliveryRequirement() {
        return this.delivery;
    }

    public String getName() {
        return this.name;
    }

    public Iterator<ClientSession> getSessions() {
        return this.clientSessions.keySet().iterator();
    }

    public boolean hasSessions() {
        return !this.clientSessions.isEmpty();
    }

    public Channel join(Set<ClientSession> sessions) {
        for (ClientSession s : sessions) {
            this.join(s);
        }
        return this;
    }

    public Channel leave(Set<ClientSession> sessions) {
        for (ClientSession s : sessions) {
            this.leave(s);
        }
        return this;
    }

    public Channel join(ClientSession clientSession) {
        this.clientSessions.put(clientSession, this.listener);
        return this;
    }

    public Channel leave(ClientSession clientSession) {
        this.clientSessions.remove(clientSession);
        return this;
    }

    public Channel leaveAll() {
        this.clientSessions.clear();
        return this;
    }

    public Channel send(ClientSession arg0, ByteBuffer arg1) {
        return this;
    }

    public Map<ClientSession, ChannelListener> getClientSessions() {
        return this.clientSessions;
    }

    public Delivery getDelivery() {
        return this.delivery;
    }

    public ChannelListener getListener() {
        return this.listener;
    }
}

