/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.mocksgs;

import com.sun.sgs.app.ChannelListener;
import com.sun.sgs.app.ChannelManager;
import com.sun.sgs.app.Delivery;
import com.sun.sgs.app.NameExistsException;
import com.sun.sgs.app.NameNotBoundException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.java.dev.mocksgs.MockChannel;
import net.java.dev.mocksgs.MockChannelFactory;

public class MockChannelManager
implements ChannelManager {
    private final Map<String, MockChannel> channels = new HashMap<String, MockChannel>();
    private MockChannelFactory channelFactory = new MockChannelFactory(){

        @Override
        public MockChannel createChannel(String channelName, ChannelListener channelListener, Delivery delivery) {
            return new MockChannel(channelName, channelListener, delivery);
        }
    };

    public void setMockChannelFactor(MockChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
    }

    public MockChannel createChannel(String channelName, ChannelListener channelListener, Delivery delivery) {
        if (channelListener != null && !(channelListener instanceof Serializable)) {
            throw new IllegalArgumentException("Channel Listener wasn't serializable: " + channelListener.getClass().getCanonicalName());
        }
        if (this.channels.containsKey(channelName)) {
            throw new NameExistsException(channelName);
        }
        MockChannel channel = this.channelFactory.createChannel(channelName, channelListener, delivery);
        this.channels.put(channelName, channel);
        return channel;
    }

    public MockChannel getChannel(String name) {
        MockChannel channel = this.channels.get(name);
        if (channel == null) {
            throw new NameNotBoundException(name);
        }
        return channel;
    }

    public Map<String, MockChannel> getChannels() {
        return this.channels;
    }
}

