/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.mocksgs;

import com.sun.sgs.app.DataManager;
import com.sun.sgs.app.ManagedObject;
import com.sun.sgs.app.ManagedObjectRemoval;
import com.sun.sgs.app.ManagedReference;
import com.sun.sgs.app.NameNotBoundException;
import com.sun.sgs.app.ObjectNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.dev.mocksgs.MockManagedReference;

public class MockDataManager
implements DataManager {
    private static BigInteger masterId = BigInteger.ZERO;
    private Map<BigInteger, ManagedObject> store = new HashMap<BigInteger, ManagedObject>();
    private Map<String, BigInteger> bindings = new HashMap<String, BigInteger>();
    private Map<ManagedObject, BigInteger> idMap = new IdentityHashMap<ManagedObject, BigInteger>();
    private Map<ManagedObject, BigInteger> removedMap = new IdentityHashMap<ManagedObject, BigInteger>();
    private List<MockManagedReference> referenceList = new ArrayList<MockManagedReference>();

    public <T> ManagedReference<T> createReference(T object) {
        this.checkArgument(object);
        this.checkRemoved(object);
        ManagedObject o = (ManagedObject)object;
        BigInteger id = this.addToDataStore(o);
        MockManagedReference m = new MockManagedReference(id);
        this.referenceList.add(m);
        return m;
    }

    public ManagedObject getBinding(String name) {
        this.checkNull(name);
        BigInteger id = this.bindings.get(name);
        if (id == null) {
            throw new NameNotBoundException("No binding for " + name + " in the data store");
        }
        return this.getObjectWithId(id);
    }

    public void markForUpdate(Object object) {
        this.checkArgument(object);
        if (!this.idMap.containsKey(object)) {
            this.checkRemoved(object);
        }
    }

    public String nextBoundName(String name) {
        ArrayList<String> names = new ArrayList<String>(this.bindings.keySet());
        Collections.sort(names);
        if (name == null) {
            if (names.size() > 0) {
                return (String)names.get(0);
            }
        } else {
            for (String next : names) {
                if (name.compareTo(next) >= 0) continue;
                return next;
            }
        }
        return null;
    }

    public void removeBinding(String name) {
        this.checkNull(name);
        if (!this.bindings.containsKey(name)) {
            throw new NameNotBoundException("No binding for " + name + " in the data store");
        }
        this.bindings.remove(name);
    }

    public void removeObject(Object object) {
        this.checkArgument(object);
        if (!this.idMap.containsKey(object)) {
            this.checkRemoved(object);
        }
        if (object instanceof ManagedObjectRemoval) {
            ((ManagedObjectRemoval)object).removingObject();
        }
        BigInteger id = this.idMap.remove(object);
        this.store.remove(id);
        this.removedMap.put((ManagedObject)object, id);
    }

    public void setBinding(String name, Object object) {
        this.checkNull(name);
        this.checkArgument(object);
        this.checkRemoved(object);
        BigInteger id = this.addToDataStore((ManagedObject)object);
        this.bindings.put(name, id);
    }

    public Set<ManagedObject> getAllData() {
        return this.idMap.keySet();
    }

    public Map<String, ManagedObject> getBoundData() {
        HashMap<String, ManagedObject> data = new HashMap<String, ManagedObject>();
        for (String name : this.bindings.keySet()) {
            data.put(name, this.store.get(this.bindings.get(name)));
        }
        return data;
    }

    public ManagedObject getObjectWithId(BigInteger id) {
        if (!this.store.containsKey(id)) {
            throw new ObjectNotFoundException("No object found in the data store with id : " + id);
        }
        return this.store.get(id);
    }

    public int size() {
        return this.store.size();
    }

    public void serializeDataStore() throws Exception {
        for (MockManagedReference r : this.referenceList) {
            r.deactivate();
        }
        this.referenceList.clear();
        for (ManagedObject m : this.idMap.keySet()) {
            BigInteger id = this.idMap.get(m);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(m);
            byte[] serializedForm = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedForm);
            ObjectInputStream ois = new ObjectInputStream(bais);
            m = (ManagedObject)ois.readObject();
            this.store.put(id, m);
        }
        this.idMap.clear();
        for (BigInteger id : this.store.keySet()) {
            ManagedObject object = this.store.get(id);
            this.idMap.put(object, id);
        }
    }

    private void checkArgument(Object object) {
        if (object == null) {
            throw new NullPointerException("The object must not be null");
        }
        if (!(object instanceof ManagedObject)) {
            throw new IllegalArgumentException("Object does not implement ManagedObject: " + System.identityHashCode(object));
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("Object does not implement Serializable: " + System.identityHashCode(object));
        }
    }

    private void checkRemoved(Object object) {
        if (this.removedMap.containsKey(object)) {
            throw new ObjectNotFoundException("Object has been previously removed from the data store: " + System.identityHashCode(object));
        }
    }

    private void checkNull(String name) {
        if (name == null) {
            throw new NullPointerException("The name must not be null");
        }
    }

    private BigInteger addToDataStore(ManagedObject object) {
        BigInteger id = this.idMap.get(object);
        if (id == null) {
            id = masterId;
            masterId = masterId.add(BigInteger.ONE);
            this.store.put(id, object);
            this.idMap.put(object, id);
        }
        return id;
    }
}

