/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.mocksgs;

import com.sun.sgs.app.AppContext;
import com.sun.sgs.app.DataManager;
import com.sun.sgs.app.ManagedReference;
import com.sun.sgs.app.TransactionNotActiveException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import net.java.dev.mocksgs.MockDataManager;

public class MockManagedReference<T>
implements ManagedReference<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BigInteger id;
    private transient boolean active;

    public MockManagedReference(BigInteger id) {
        this.id = id;
        this.active = true;
    }

    public T get() {
        return this.internalGet();
    }

    public T getForUpdate() {
        return this.internalGet();
    }

    private T internalGet() {
        if (!this.active) {
            throw new TransactionNotActiveException("Transaction not active");
        }
        DataManager dm = AppContext.getDataManager();
        if (!(dm instanceof MockDataManager)) {
            throw new IllegalStateException("MockManagedReference cannot be used without  a backing MockDataManager");
        }
        return (T)((MockDataManager)dm).getObjectWithId(this.id);
    }

    public BigInteger getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof MockManagedReference) {
            return ((MockManagedReference)object).id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        long oid = this.id.longValue();
        return (int)(oid ^ oid >>> 32) + 6883;
    }

    void deactivate() {
        this.active = false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.active = true;
    }
}

