/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.mocksgs;

import com.sun.sgs.app.ExceptionRetryStatus;
import com.sun.sgs.app.PeriodicTaskHandle;
import com.sun.sgs.app.Task;
import com.sun.sgs.app.TaskManager;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.dev.mocksgs.AbstractMockTaskHandle;
import net.java.dev.mocksgs.MockPeriodicTaskHandle;
import net.java.dev.mocksgs.MockScheduledTaskHandle;

public class MockTaskManager
implements TaskManager {
    private static final Logger logger = Logger.getLogger(MockTaskManager.class.getName());
    private PriorityQueue<AbstractMockTaskHandle> scheduledTaskHandles = new PriorityQueue();
    private long mockTime = 0L;

    public PeriodicTaskHandle schedulePeriodicTask(Task task, long delay, long period) {
        this.checkArgument(task);
        this.checkPositive("Delay", delay);
        this.checkPositive("Period", period);
        MockPeriodicTaskHandle handle = new MockPeriodicTaskHandle(task, delay, period, this.getMockTimeMillis() + delay);
        this.scheduledTaskHandles.add(handle);
        return handle;
    }

    public void scheduleTask(Task task, long delay) {
        this.checkArgument(task);
        this.checkPositive("Delay", delay);
        this.scheduledTaskHandles.add(new MockScheduledTaskHandle(task, delay, this.getMockTimeMillis() + delay));
    }

    public void scheduleTask(Task task) {
        this.scheduleTask(task, 0L);
    }

    public List<PeriodicTaskHandle> getPeriodicTaskHandles() {
        LinkedList<PeriodicTaskHandle> list = new LinkedList<PeriodicTaskHandle>();
        for (AbstractMockTaskHandle handle : this.scheduledTaskHandles) {
            if (!(handle instanceof PeriodicTaskHandle)) continue;
            list.add((PeriodicTaskHandle)handle);
        }
        return list;
    }

    public List<MockScheduledTaskHandle> getScheduledTaskHandles() {
        LinkedList<MockScheduledTaskHandle> list = new LinkedList<MockScheduledTaskHandle>();
        for (AbstractMockTaskHandle handle : this.scheduledTaskHandles) {
            if (!(handle instanceof MockScheduledTaskHandle)) continue;
            list.add((MockScheduledTaskHandle)handle);
        }
        return list;
    }

    public void reset() {
        this.scheduledTaskHandles.clear();
    }

    public int getTotalTaskCount() {
        return this.scheduledTaskHandles.size();
    }

    public boolean isTaskQueueEmpty() {
        return this.scheduledTaskHandles.isEmpty();
    }

    public long getNextTaskScheduleTime() {
        return !this.scheduledTaskHandles.isEmpty() ? this.scheduledTaskHandles.peek().getScheduleTime() : -1L;
    }

    public void executeNextTaskTick() {
        long nextTaskScheduleTime = this.getNextTaskScheduleTime();
        if (nextTaskScheduleTime != -1L) {
            this.mockTime = Math.max(nextTaskScheduleTime, this.mockTime);
            this.executeCurrentTick();
        }
    }

    public void executeCurrentTick() {
        AbstractMockTaskHandle nextTask = this.scheduledTaskHandles.peek();
        if (nextTask != null && nextTask.getScheduleTime() <= this.mockTime) {
            this.scheduledTaskHandles.poll();
            try {
                nextTask.getTask().run();
                if (nextTask instanceof MockPeriodicTaskHandle) {
                    long repeat = ((MockPeriodicTaskHandle)nextTask).getRepeat();
                    this.scheduledTaskHandles.add(new MockPeriodicTaskHandle(nextTask.getTask(), nextTask.getStart(), repeat, this.mockTime + repeat));
                }
            }
            catch (Exception e) {
                if (e instanceof ExceptionRetryStatus) {
                    if (((ExceptionRetryStatus)e).shouldRetry()) {
                        logger.log(Level.SEVERE, "Task requests retry, rescheduling it.", e);
                        this.scheduledTaskHandles.add(nextTask);
                    } else {
                        logger.log(Level.SEVERE, "Task does not want to be retried, not rescheduling.", e);
                    }
                }
                logger.log(Level.SEVERE, "Task failed with a non-retryable exception, not rescheduling.", e);
            }
        }
    }

    public long getMockTimeMillis() {
        return this.mockTime;
    }

    public void setMockTimeMillis(long time) {
        this.mockTime = time;
    }

    private void checkArgument(Task task) {
        if (task == null) {
            throw new NullPointerException("The task must not be null");
        }
        if (!(task instanceof Serializable)) {
            throw new IllegalArgumentException("Task is not serializable: " + task);
        }
    }

    private void checkPositive(String name, long num) {
        if (num < 0L) {
            throw new IllegalArgumentException(name + " is less than zero: " + num);
        }
    }
}

