/*
 * Decompiled with CFR 0.152.
 */
package net.java.openjdk.cacio.ctc;

import java.awt.Rectangle;
import java.awt.peer.RobotPeer;
import net.java.openjdk.cacio.ctc.CTCEventSource;
import net.java.openjdk.cacio.ctc.CTCScreen;
import net.java.openjdk.cacio.ctc.KeyStrokeMappingFactory;
import net.java.openjdk.cacio.ctc.MouseClickSupport;
import sun.awt.peer.cacio.CacioMouseInfoPeer;
import sun.awt.peer.cacio.managed.EventData;

public class CTCRobotPeer
implements RobotPeer {
    private static final int BUTTON_MASK_CONVERSION_SHIFT = 6;
    private static final int BUTTON_MASKS = 28;
    private static final int BUTTON_DOWN_MASKS = 7168;
    private int currentModifiers = 0;
    private int currentX = 0;
    private int currentY = 0;
    private MouseClickSupport mouseClickSupport = new MouseClickSupport();

    private EventData mouseEvent(int id, int currentButton, boolean popup) {
        EventData ev = new EventData();
        ev.setId(id);
        ev.setSource((Object)CTCScreen.getInstance());
        ev.setTime(System.currentTimeMillis());
        ev.setModifiers(this.currentModifiers);
        ev.setX(this.currentX);
        ev.setY(this.currentY);
        ev.setButton(currentButton);
        ev.setPopup(popup);
        ev.setClickCount(this.mouseClickSupport.getClickCount());
        return ev;
    }

    @Override
    public void mouseMove(int x, int y) {
        this.currentX = x;
        this.currentY = y;
        EventData ev = this.mouseEvent(503, 0, false);
        CTCEventSource.getInstance().postEvent(ev);
        CacioMouseInfoPeer.getInstance().setMouseScreenCoordinates(x, y);
    }

    @Override
    public void mousePress(int buttons) {
        int buttonMask = this.buttonDownToButtonMask(buttons);
        int buttonDownMask = this.buttonToButtonDownMask(buttons);
        if (buttonDownMask != 0 && buttonMask != 0) {
            this.currentModifiers |= buttonMask;
            EventData ev = this.mouseEvent(501, buttonDownMask, false);
            this.mouseClickSupport.mouseEvent(ev);
            ev = this.mouseEvent(501, buttonDownMask, false);
            CTCEventSource.getInstance().postEvent(ev);
        }
    }

    @Override
    public void mouseRelease(int buttons) {
        int buttonMask = this.buttonDownToButtonMask(buttons);
        int buttonDownMask = this.buttonToButtonDownMask(buttons);
        if (buttonDownMask != 0 && buttonMask != 0) {
            EventData ev = this.mouseEvent(502, buttonDownMask, (buttons & 4) != 0);
            CTCEventSource.getInstance().postEvent(ev);
            ev = this.mouseEvent(502, buttonDownMask, false);
            this.mouseClickSupport.mouseEvent(ev);
            this.currentModifiers &= ~buttonMask;
        }
    }

    private int buttonToButtonDownMask(int buttons) {
        int buttonDownMask = buttons & 0x1C00;
        return buttonDownMask |= (buttons & 0x1C) << 6;
    }

    private int buttonDownToButtonMask(int buttons) {
        int buttonMask = buttons & 0x1C;
        return buttonMask |= (buttons & 0x1C00) >> 6;
    }

    @Override
    public void mouseWheel(int wheelAmt) {
    }

    private void keyEvent(int keycode, int id) {
        EventData ev = new EventData();
        ev.setSource((Object)CTCScreen.getInstance());
        ev.setId(id);
        ev.setTime(System.currentTimeMillis());
        ev.setModifiers(this.currentModifiers);
        ev.setKeyCode(keycode);
        CTCEventSource.getInstance().postEvent(ev);
    }

    @Override
    public void keyPress(int keycode) {
        if (keycode == 16) {
            this.currentModifiers |= 1;
        }
        if (keycode == 17) {
            this.currentModifiers |= 2;
        }
        if (keycode == 65406) {
            this.currentModifiers |= 0x20;
        }
        this.keyEvent(keycode, 401);
        char keychar = this.getKeyCharFromCodeAndMods(keycode, this.currentModifiers);
        if (keychar != '\uffff') {
            EventData ev = new EventData();
            ev.setSource((Object)CTCScreen.getInstance());
            ev.setId(400);
            ev.setTime(System.currentTimeMillis());
            ev.setModifiers(this.currentModifiers);
            ev.setKeyChar(keychar);
            CTCEventSource.getInstance().postEvent(ev);
        }
    }

    private char getKeyCharFromCodeAndMods(int keyCode, int modifiers) {
        return KeyStrokeMappingFactory.getInstance().getKeyStrokeMapping().getKeyChar(keyCode, modifiers);
    }

    @Override
    public void keyRelease(int keycode) {
        if (keycode == 16) {
            this.currentModifiers &= 0xFFFFFFFE;
        }
        if (keycode == 17) {
            this.currentModifiers &= 0xFFFFFFFD;
        }
        if (keycode == 65406) {
            this.currentModifiers &= 0xFFFFFFDF;
        }
        this.keyEvent(keycode, 402);
    }

    @Override
    public int getRGBPixel(int x, int y) {
        return 0;
    }

    @Override
    public int[] getRGBPixels(Rectangle bounds) {
        return CTCScreen.getInstance().getRGBPixels(bounds);
    }

    public void dispose() {
    }
}

