/*
 * Decompiled with CFR 0.152.
 */
package net.java.openjdk.cacio.ctc;

import net.java.openjdk.cacio.ctc.CTCEventSource;
import net.java.openjdk.cacio.ctc.CTCScreen;
import sun.awt.peer.cacio.managed.EventData;

class MouseClickSupport {
    private static final long MULTI_CLICK_THRESHOLD = 400L;
    private EventData lastPress;
    private int clickCount;

    MouseClickSupport() {
    }

    void mouseEvent(EventData ev) {
        switch (ev.getId()) {
            case 501: {
                this.handlePress(ev);
                break;
            }
            case 502: {
                this.handleRelease(ev);
                break;
            }
        }
    }

    private void handlePress(EventData ev) {
        this.clickCount = this.isInMultiClickThreshold(ev) && this.isClick(ev) ? ++this.clickCount : 1;
        this.lastPress = ev;
    }

    private boolean isInMultiClickThreshold(EventData ev) {
        return this.lastPress != null && ev.getTime() - this.lastPress.getTime() < 400L;
    }

    private void handleRelease(EventData ev) {
        if (this.isClick(ev)) {
            this.generateClick(ev);
        }
    }

    private void generateClick(EventData ev) {
        ev.setId(500);
        ev.setSource((Object)CTCScreen.getInstance());
        ev.setTime(System.currentTimeMillis());
        ev.setClickCount(this.clickCount);
        ev.setPopup(false);
        CTCEventSource.getInstance().postEvent(ev);
    }

    private boolean isClick(EventData ev) {
        return this.lastPress.getButton() == ev.getButton() && this.lastPress.getX() == ev.getX() && this.lastPress.getY() == ev.getY();
    }

    int getClickCount() {
        return this.clickCount;
    }
}

