/*
 * Decompiled with CFR 0.152.
 */
package net.java.openjdk.cacio.ctc.junit;

import java.lang.reflect.Method;
import net.java.openjdk.cacio.ctc.junit.CacioTestRunner;
import org.fest.swing.annotation.GUITestFinder;
import org.fest.swing.junit.runner.FailureScreenshotTaker;
import org.fest.swing.junit.runner.Formatter;
import org.fest.swing.junit.runner.ImageFolderCreator;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CacioFESTRunner
extends CacioTestRunner {
    public CacioFESTRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new MethodInvoker(method, test, new FailureScreenshotTaker(new ImageFolderCreator().createImageFolder()));
    }

    class MethodInvoker
    extends Statement {
        private final FrameworkMethod testMethod;
        private final Object target;
        private final FailureScreenshotTaker screenshotTaker;

        MethodInvoker(FrameworkMethod testMethod, Object target, FailureScreenshotTaker screenshotTaker) {
            this.testMethod = testMethod;
            this.target = target;
            this.screenshotTaker = screenshotTaker;
        }

        public void evaluate() throws Throwable {
            try {
                this.testMethod.invokeExplosively(this.target, new Object[0]);
            }
            catch (Throwable t) {
                this.takeScreenshot();
                throw t;
            }
        }

        private void takeScreenshot() {
            Method realMethod = this.testMethod.getMethod();
            Class<?> testClass = realMethod.getDeclaringClass();
            if (!GUITestFinder.isGUITest(testClass, (Method)realMethod)) {
                return;
            }
            this.screenshotTaker.saveScreenshot(Formatter.testNameFrom(testClass, (Method)realMethod));
        }
    }
}

