/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class CanonicalStringSet
extends AbstractSet<String> {
    private final Canonicalizer canonicalizer;
    private final char separator;
    private final Set<String> set = new TreeSet<String>();

    public CanonicalStringSet(Canonicalizer canonicalizer, char separator) {
        this.canonicalizer = Objects.requireNonNull(canonicalizer);
        this.separator = separator;
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public String toString() {
        int capacity = this.size() * 11;
        if (0 >= capacity) {
            return "";
        }
        StringBuilder s = new StringBuilder(capacity);
        for (String string : this) {
            if (s.length() > 0) {
                s.append(this.separator);
            }
            s.append(string);
        }
        return s.toString();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(this.canonicalizer.map(o));
    }

    @Override
    public boolean add(String e) {
        return this.set.add(this.canonicalizer.map(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(this.canonicalizer.map(o));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public boolean containsAll(CanonicalStringSet set) {
        return this.set.containsAll(set.set);
    }

    public boolean containsAll(String list) {
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            if (this.set.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(CanonicalStringSet set) {
        boolean changed = false;
        for (String s : set.set) {
            changed |= this.add(s);
        }
        return changed;
    }

    public boolean addAll(String list) {
        boolean changed = false;
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            changed |= this.set.add((String)i.next());
        }
        return changed;
    }

    public boolean retainAll(CanonicalStringSet set) {
        return this.set.retainAll(set.set);
    }

    public boolean retainAll(String list) {
        CanonicalStringSet set = new CanonicalStringSet(this.canonicalizer, this.separator);
        set.addAll(list);
        return this.set.retainAll(set);
    }

    public boolean removeAll(CanonicalStringSet set) {
        return this.set.removeAll(set.set);
    }

    public boolean removeAll(String list) {
        boolean changed = false;
        CanonicalStringIterator i = new CanonicalStringIterator(list);
        while (i.hasNext()) {
            changed |= this.set.remove(i.next());
        }
        return changed;
    }

    private class CanonicalStringIterator
    implements Iterator<String> {
        private final StringTokenizer tokenizer;
        @Nullable
        private String canonical;

        private CanonicalStringIterator(String list) {
            this.tokenizer = new StringTokenizer(list, "" + CanonicalStringSet.this.separator);
            this.advance();
        }

        private void advance() {
            while (this.tokenizer.hasMoreTokens()) {
                this.canonical = CanonicalStringSet.this.canonicalizer.map(this.tokenizer.nextToken());
                if (null == this.canonical) continue;
                return;
            }
            this.canonical = null;
        }

        @Override
        public boolean hasNext() {
            return null != this.canonical;
        }

        @Override
        public String next() {
            String canonical = this.canonical;
            if (null == canonical) {
                throw new NoSuchElementException();
            }
            this.advance();
            return canonical;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Canonicalizer {
        public String map(Object var1);
    }
}

