/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.CanonicalStringSet;

@NotThreadSafe
public final class ExtensionSet
extends CanonicalStringSet {
    public static final char SEPARATOR = '|';
    public static final char PREFIX = '.';

    public ExtensionSet() {
        super(new ExtensionMapper(), '|');
    }

    public ExtensionSet(String extensions) {
        super(new ExtensionMapper(), '|');
        super.addAll(extensions);
    }

    public ExtensionSet(Collection<String> c) {
        super(new ExtensionMapper(), '|');
        super.addAll(c);
    }

    public Pattern toPattern() {
        Iterator<String> i = this.iterator();
        if (i.hasNext()) {
            StringBuilder sb = new StringBuilder(".*\\.(?i)(");
            int c = 0;
            do {
                String extension = i.next();
                if (0 < c++) {
                    sb.append('|');
                }
                sb.append("\\Q").append(extension).append("\\E");
            } while (i.hasNext());
            assert (0 < c);
            return Pattern.compile(sb.append(")[\\").append(File.separatorChar).append("/]*").toString());
        }
        return Pattern.compile("\\00");
    }

    private static class ExtensionMapper
    implements CanonicalStringSet.Canonicalizer {
        private ExtensionMapper() {
        }

        @Override
        public String map(Object o) {
            String extension = o.toString();
            while (0 < extension.length() && extension.charAt(0) == '.') {
                extension = extension.substring(1);
            }
            return extension.toLowerCase(Locale.ROOT);
        }
    }
}

