/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.swing;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.swing.TFileSystemView;
import net.java.truevfs.access.swing.TFileView;

public final class TFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 936528972682036204L;

    public TFileChooser() {
        this(null, null);
    }

    public TFileChooser(@CheckForNull TFile currentDirectory) {
        this(currentDirectory, null);
    }

    public TFileChooser(@CheckForNull TFileSystemView fileSystemView) {
        this(null, fileSystemView);
    }

    public TFileChooser(@CheckForNull TFile currentDirectory, @CheckForNull TFileSystemView fileSystemView) {
        super((File)currentDirectory, (FileSystemView)(null != fileSystemView ? fileSystemView : new TFileSystemView()));
        super.setFileView(new TFileView(super.getFileView()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        super.setFileSystemView(new TFileSystemView());
    }

    public TFile getCurrentDirectory() {
        return this.getFileSystemView().wrap(super.getCurrentDirectory());
    }

    @Override
    public TFileSystemView getFileSystemView() {
        return (TFileSystemView)super.getFileSystemView();
    }

    @Override
    public void setFileSystemView(FileSystemView fileSystemView) {
        super.setFileSystemView((TFileSystemView)Objects.requireNonNull(fileSystemView));
    }

    @Nullable
    public TFile getSelectedFile() {
        return this.getFileSystemView().wrap(super.getSelectedFile());
    }

    @Nullable
    public TFile[] getSelectedFiles() {
        File[] files = super.getSelectedFiles();
        TFile[] tfiles = new TFile[files.length];
        TFileSystemView fsv = this.getFileSystemView();
        int i = files.length;
        while (0 <= --i) {
            tfiles[i] = fsv.wrap(files[i]);
        }
        return tfiles;
    }
}

