/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.MutableBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.util.SuspensionPenalty;
import net.java.truevfs.comp.zip.WinZipAesCipher;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.WinZipAesExtraField;
import net.java.truevfs.comp.zip.ZipAuthenticationException;
import net.java.truevfs.comp.zip.ZipCryptoException;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.crypto.CipherReadOnlyChannel;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class WinZipAesReadOnlyChannel
extends ReadOnlyChannel {
    private static final int MAC_SIZE = WinZipAesReadOnlyChannel.newMac().getMacSize();
    private final ByteBuffer authenticationCode;
    private final KeyParameter sha1MacParam;
    private final ZipEntry entry;

    private static Mac newMac() {
        return new HMac((Digest)new SHA1Digest());
    }

    @CreatesObligation
    WinZipAesReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel, WinZipAesEntryParameters param) throws IOException {
        super(channel);
        KeyParameter sha1MacParam;
        ParametersWithIV aesCtrParam;
        KeyParameter keyParam;
        ZipEntry entry = param.getEntry();
        assert (entry.isEncrypted());
        WinZipAesExtraField field = (WinZipAesExtraField)entry.getExtraField(39169);
        if (null == field) {
            throw new ZipCryptoException(entry.getName() + " (missing extra field for WinZip AES entry)");
        }
        AesKeyStrength keyStrength = field.getKeyStrength();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        ByteBuffer salt = ((MutableBuffer)MutableBuffer.allocate((int)(keyStrengthBytes / 2)).load((ReadableByteChannel)channel.position(0L))).buffer();
        ByteBuffer passwdVerifier = ((MutableBuffer)MutableBuffer.allocate((int)2).load((ReadableByteChannel)channel)).buffer();
        MutableBuffer footer = MutableBuffer.allocate((int)(MAC_SIZE / 2));
        long start = channel.position();
        long end = channel.size() - (long)footer.remaining();
        long size = end - start;
        if (0L > size) {
            throw new ZipCryptoException(entry.getName() + " (false positive WinZip AES entry is too short)", new EOFException());
        }
        footer.load((ReadableByteChannel)channel.position(end));
        if (channel.position() != channel.size()) {
            throw new ZipCryptoException("Expected end of file after WinZip AES authentication code!");
        }
        this.authenticationCode = footer.buffer();
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        long lastTry = 0L;
        do {
            byte[] passwd = param.getReadPassword(0L != lastTry);
            assert (null != passwd);
            gen.init(passwd, salt.array(), 1000);
            assert (128 <= keyStrengthBits);
            keyParam = (KeyParameter)gen.generateDerivedParameters(2 * keyStrengthBits + 16);
            Arrays.fill(passwd, (byte)0);
            byte[] ctrIv = new byte[16];
            aesCtrParam = new ParametersWithIV((CipherParameters)new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
            sha1MacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
            lastTry = SuspensionPenalty.enforce((long)lastTry);
        } while (!passwdVerifier.equals(ByteBuffer.wrap(keyParam.getKey()).position(2 * keyStrengthBytes)));
        this.sha1MacParam = sha1MacParam;
        this.entry = entry;
        WinZipAesCipher cipher = new WinZipAesCipher();
        cipher.init(false, (CipherParameters)aesCtrParam);
        this.channel = new CipherReadOnlyChannel(cipher, (SeekableByteChannel)new IntervalReadOnlyChannel(channel.position(start), size));
        param.setKeyStrength(keyStrength);
    }

    void authenticate() throws IOException {
        Mac mac = WinZipAesReadOnlyChannel.newMac();
        mac.init((CipherParameters)this.sha1MacParam);
        byte[] buf = ((CipherReadOnlyChannel)((Object)this.channel)).mac(mac);
        if (!this.authenticationCode.equals(ByteBuffer.wrap(buf, 0, buf.length / 2))) {
            throw new ZipAuthenticationException(this.entry.getName() + " (authenticated WinZip AES entry content has been tampered with)");
        }
    }
}

