/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.BufferedReadOnlyChannel;
import net.java.truecommons.io.ChannelInputStream;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.MutableBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.io.Source;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.CountingInputStream;
import net.java.truevfs.comp.zip.Crc32Exception;
import net.java.truevfs.comp.zip.Crc32InputStream;
import net.java.truevfs.comp.zip.DummyByteChannelInputStream;
import net.java.truevfs.comp.zip.OffsetPositionMapper;
import net.java.truevfs.comp.zip.PositionMapper;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.WinZipAesExtraField;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.WinZipAesReadOnlyChannel;
import net.java.truevfs.comp.zip.WinZipAesUtils;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipEntryFactory;
import net.java.truevfs.comp.zip.ZipFileParameters;
import net.java.truevfs.comp.zip.ZipInflaterInputStream;
import net.java.truevfs.comp.zip.ZipParametersUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

@CleanupObligation
@NotThreadSafe
public abstract class AbstractZipFile<E extends ZipEntry>
implements Closeable,
Iterable<E> {
    private static final int LFH_FILE_NAME_LENGTH_POS = 26;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    @CheckForNull
    private SeekableByteChannel channel;
    private long length;
    private long preamble;
    private long postamble;
    private final ZipEntryFactory<E> param;
    private Charset charset;
    @CheckForNull
    private byte[] comment;
    private Map<String, E> entries;
    private PositionMapper mapper = new PositionMapper();
    private int open;

    @CreatesObligation
    protected AbstractZipFile(Source source, ZipFileParameters<E> param) throws ZipException, EOFException, IOException {
        this.param = param;
        SeekableByteChannel channel = this.channel = source.channel();
        try {
            this.length = channel.size();
            this.charset = param.getCharset();
            SafeBufferedReadOnlyChannel bchannel = new SafeBufferedReadOnlyChannel(channel, this.length);
            if (!param.getPreambled()) {
                this.checkZipFileSignature((SeekableByteChannel)((Object)bchannel));
            }
            int numEntries = this.findCentralDirectory((SeekableByteChannel)((Object)bchannel), param.getPostambled());
            this.mountCentralDirectory((SeekableByteChannel)((Object)bchannel), numEntries);
            if (this.preamble + this.postamble >= this.length) {
                assert (0 == numEntries);
                if (param.getPreambled()) {
                    this.checkZipFileSignature((SeekableByteChannel)((Object)bchannel));
                }
            }
            assert (null != channel);
            assert (null != this.charset);
            assert (null != this.entries);
            assert (null != this.mapper);
        }
        catch (Throwable e1) {
            try {
                channel.close();
            }
            catch (Throwable e2) {
                e1.addSuppressed(e2);
            }
            throw e1;
        }
    }

    private void checkZipFileSignature(SeekableByteChannel channel) throws IOException {
        long sig = ((MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)4).littleEndian()).load((ReadableByteChannel)channel.position(this.preamble))).getUInt();
        if (67324752L != sig && 101075792L != sig && 101010256L != sig) {
            throw new ZipException("Expected local file header or (ZIP64) end of central directory record!");
        }
    }

    private int findCentralDirectory(SeekableByteChannel channel, boolean postambled) throws IOException {
        MutableBuffer eocdr = (MutableBuffer)MutableBuffer.allocate((int)22).littleEndian();
        long max = this.length - 22L;
        long min = !postambled && max >= 65535L ? max - 65535L : 0L;
        for (long eocdrPos = max; eocdrPos >= min; --eocdrPos) {
            ((MutableBuffer)((MutableBuffer)eocdr.rewind()).limit(4)).load((ReadableByteChannel)channel.position(eocdrPos));
            if (101010256L != eocdr.getUInt()) continue;
            try {
                ((MutableBuffer)eocdr.limit(22)).load((ReadableByteChannel)channel);
                long diskNo = eocdr.getUShort();
                long cdDiskNo = eocdr.getUShort();
                long cdEntriesDisk = eocdr.getUShort();
                long cdEntries = eocdr.getUShort();
                if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                    throw new ZipException("ZIP file spanning/splitting is not supported!");
                }
                long cdSize = eocdr.getUInt();
                long cdPos = eocdr.getUInt();
                int commentLen = eocdr.getUShort();
                if (0 < commentLen) {
                    this.comment = ((MutableBuffer)MutableBuffer.allocate((int)commentLen).load((ReadableByteChannel)channel)).array();
                }
                this.preamble = eocdrPos;
                this.postamble = this.length - channel.position();
                long eocdlPos = eocdrPos - 20L;
                MutableBuffer zip64eocdl = (MutableBuffer)MutableBuffer.allocate((int)20).littleEndian();
                if (0L > eocdlPos || 117853008L != ((MutableBuffer)zip64eocdl.load((ReadableByteChannel)channel.position(eocdlPos))).getUInt()) {
                    long offset = eocdrPos - cdSize;
                    channel.position(offset);
                    if (0L != (offset -= cdPos)) {
                        this.mapper = new OffsetPositionMapper(offset);
                    }
                    return (int)cdEntries;
                }
                long zip64eocdrDisk = zip64eocdl.getUInt();
                long zip64eocdrPos = zip64eocdl.getLong();
                long totalDisks = zip64eocdl.getUInt();
                if (0L != zip64eocdrDisk || 1L != totalDisks) {
                    throw new ZipException("ZIP file spanning/splitting is not supported!");
                }
                MutableBuffer zip64eocdr = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)56).littleEndian()).load((ReadableByteChannel)channel.position(zip64eocdrPos));
                if (101075792L != zip64eocdr.getUInt()) {
                    throw new ZipException("Expected ZIP64 end of central directory record!");
                }
                zip64eocdr.skip(12);
                diskNo = zip64eocdr.getUInt();
                cdDiskNo = zip64eocdr.getUInt();
                cdEntriesDisk = zip64eocdr.getLong();
                cdEntries = zip64eocdr.getLong();
                if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                    throw new ZipException("ZIP file spanning/splitting is not supported!");
                }
                if (cdEntries < 0L || Integer.MAX_VALUE < cdEntries) {
                    throw new ZipException("Total number of entries in the central directory out of range!");
                }
                zip64eocdr.skip(8);
                cdPos = zip64eocdr.getLong();
                channel.position(cdPos);
                this.preamble = zip64eocdrPos;
                return (int)cdEntries;
            }
            catch (RuntimeException e) {
                throw (ZipException)new ZipException("Invalid (ZIP64) End Of Central Directory Record").initCause(e);
            }
        }
        this.preamble = min;
        this.postamble = this.length - min;
        return 0;
    }

    private void mountCentralDirectory(SeekableByteChannel channel, int numEntries) throws IOException {
        MutableBuffer cfh = (MutableBuffer)MutableBuffer.allocate((int)46).littleEndian();
        LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>(Math.max(HashMaps.initialCapacity((int)numEntries), 16));
        while (true) {
            boolean utf8;
            ((MutableBuffer)((MutableBuffer)cfh.rewind()).limit(4)).load((ReadableByteChannel)channel);
            if (33639248L != cfh.getUInt()) break;
            ((MutableBuffer)cfh.limit(46)).load((ReadableByteChannel)channel);
            int gpbf = ((MutableBuffer)cfh.position(8)).getUShort();
            int nameLen = ((MutableBuffer)cfh.position(28)).getUShort();
            MutableBuffer name = (MutableBuffer)MutableBuffer.allocate((int)nameLen).load((ReadableByteChannel)channel);
            boolean bl = utf8 = 0 != (gpbf & 0x800);
            if (utf8) {
                this.charset = Constants.UTF8;
            }
            E entry = this.param.newEntry(this.decode(name.array()));
            try {
                cfh.position(4);
                ((ZipEntry)entry).setRawPlatform(cfh.getUShort() >> 8);
                cfh.skip(4);
                ((ZipEntry)entry).setGeneralPurposeBitFlags(gpbf);
                ((ZipEntry)entry).setRawMethod(cfh.getUShort());
                ((ZipEntry)entry).setRawTime(cfh.getUInt());
                ((ZipEntry)entry).setRawCrc(cfh.getUInt());
                ((ZipEntry)entry).setRawCompressedSize(cfh.getUInt());
                ((ZipEntry)entry).setRawSize(cfh.getUInt());
                cfh.skip(2);
                int extraLen = cfh.getUShort();
                int commentLen = cfh.getUShort();
                cfh.skip(4);
                ((ZipEntry)entry).setRawExternalAttributes(cfh.getUInt());
                long lfhOff = cfh.getUInt();
                ((ZipEntry)entry).setRawOffset(lfhOff);
                if (0 < extraLen) {
                    ((ZipEntry)entry).setRawExtraFields(((MutableBuffer)MutableBuffer.allocate((int)extraLen).load((ReadableByteChannel)channel)).array());
                }
                if (0 < commentLen) {
                    ((ZipEntry)entry).setRawComment(this.decode(((MutableBuffer)MutableBuffer.allocate((int)commentLen).load((ReadableByteChannel)channel)).array()));
                }
                if ((lfhOff = this.mapper.map(((ZipEntry)entry).getOffset())) < this.preamble) {
                    this.preamble = lfhOff;
                }
            }
            catch (RuntimeException e) {
                throw (ZipException)new ZipException(((ZipEntry)entry).getName() + " (invalid Central File Header)").initCause(e);
            }
            entries.put(((ZipEntry)entry).getName(), entry);
            --numEntries;
        }
        if (0 != numEntries % 65536) {
            throw new ZipException("Expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the central directory!");
        }
        this.entries = entries;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public AbstractZipFile<E> recoverLostEntries() throws ZipException, EOFException, IOException {
        length = this.length;
        channel = new SafeBufferedReadOnlyChannel(this.channel(), length);
        while (0L < this.postamble) {
            block45: {
                pos = length - this.postamble;
                lfh = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)30).littleEndian()).load((ReadableByteChannel)channel.position(pos));
                if (67324752L != lfh.getUInt()) {
                    throw new ZipException("Expected local file header!");
                }
                gpbf = ((MutableBuffer)lfh.position(6)).getUShort();
                nameLen = ((MutableBuffer)lfh.position(26)).getUShort();
                if (0 != (gpbf & 2048)) {
                    this.charset = Constants.UTF8;
                }
                entry = this.param.newEntry(this.decode(((MutableBuffer)MutableBuffer.allocate((int)nameLen).load((ReadableByteChannel)channel)).array()));
                try {
                    entry.setGeneralPurposeBitFlags(gpbf);
                    lfh.position(8);
                    entry.setRawMethod(lfh.getUShort());
                    entry.setRawTime(lfh.getUInt());
                    entry.setRawCrc(lfh.getUInt());
                    entry.setRawCompressedSize(lfh.getUInt());
                    entry.setRawSize(lfh.getUInt());
                    lfh.skip(2);
                    extraLen = lfh.getUShort();
                    entry.setRawOffset(this.mapper.unmap(pos));
                    if (0 < extraLen) {
                        entry.setRawExtraFields(((MutableBuffer)MutableBuffer.allocate((int)extraLen).load((ReadableByteChannel)channel)).array());
                    }
                    if (entry.getGeneralPurposeBitFlag(8)) {
                        start = pos = channel.position();
                        echannel /* !! */  = new IntervalReadOnlyChannel((SeekableByteChannel)channel, pos, length - pos);
                        field = null;
                        method = entry.getMethod();
                        if (entry.isEncrypted()) {
                            if (99 != method) {
                                throw new ZipException(entry.getName() + " (encrypted compression method " + method + " is not supported)");
                            }
                            echannel /* !! */  = new WinZipAesReadOnlyChannel((SeekableByteChannel)echannel /* !! */ , new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), (ZipEntry)entry));
                            field = (WinZipAesExtraField)entry.getExtraField(39169);
                            method = field.getMethod();
                        }
                        bufSize = AbstractZipFile.getBufferSize(entry);
                        din = null;
                        switch (method) {
                            case 8: {
                                in = new ZipInflaterInputStream((InputStream)new DummyByteChannelInputStream((SeekableByteChannel)echannel /* !! */ ), bufSize);
                                break;
                            }
                            case 12: {
                                din = new CountingInputStream((InputStream)new ChannelInputStream((SeekableByteChannel)echannel /* !! */ ));
                                try {
                                    in = new BZip2CompressorInputStream((InputStream)din);
                                    break;
                                }
                                catch (Throwable e1) {
                                    try {
                                        din.close();
                                    }
                                    catch (Throwable e2) {
                                        e1.addSuppressed(e2);
                                    }
                                    throw e1;
                                }
                            }
                            default: {
                                throw new ZipException(entry.getName() + " (compression method " + method + " is not supported)");
                            }
                        }
                        cin = new CheckedInputStream(in, new CRC32());
                        e2 = null;
                        try {
                            entry.setRawSize(cin.skip(0x7FFFFFFFFFFFFFFFL));
                            if (null != field && field.getVendorVersion() == 2) {
                                entry.setRawCrc(0L);
                            } else {
                                entry.setRawCrc(cin.getChecksum().getValue());
                            }
                            switch (method) {
                                case 8: {
                                    inf = in.getInflater();
                                    if (!AbstractZipFile.$assertionsDisabled && !inf.finished()) {
                                        throw new AssertionError();
                                    }
                                    pos += inf.getBytesRead();
                                    ** break;
lbl74:
                                    // 1 sources

                                    break;
                                }
                                case 12: {
                                    pos += din.getBytesRead();
                                    ** break;
lbl78:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        catch (Throwable var21_24) {
                            e2 = var21_24;
                            throw var21_24;
                        }
                        finally {
                            if (cin != null) {
                                if (e2 != null) {
                                    try {
                                        cin.close();
                                    }
                                    catch (Throwable x2) {
                                        e2.addSuppressed(x2);
                                    }
                                } else {
                                    cin.close();
                                }
                            }
                        }
                        if (null != field) {
                            pos += (long)WinZipAesUtils.overhead(field.getKeyStrength());
                        }
                        entry.setRawCompressedSize(pos - start);
                        dd = (MutableBuffer)((MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)(entry.isZip64ExtensionsRequired() != false ? 20 : 12)).littleEndian()).limit(4)).load((ReadableByteChannel)channel.position(pos));
                        crc = dd.getUInt();
                        if (134695760L == crc) {
                            dd.rewind();
                        }
                        ((MutableBuffer)dd.limit(dd.capacity())).load((ReadableByteChannel)channel);
                        crc = ((MutableBuffer)dd.position(0)).getUInt();
                        if (entry.isZip64ExtensionsRequired()) {
                            csize = dd.getLong();
                            size = dd.getLong();
                        } else {
                            csize = dd.getUInt();
                            size = dd.getUInt();
                        }
                        if (entry.getCrc() != crc) {
                            throw new Crc32Exception(entry.getName(), entry.getCrc(), crc);
                        }
                        if (entry.getCompressedSize() != csize) {
                            throw new ZipException(entry.getName() + " (invalid compressed size in data descriptor)");
                        }
                        if (entry.getSize() != size) {
                            throw new ZipException(entry.getName() + " (invalid uncompressed size in data descriptor)");
                        }
                        break block45;
                    }
                    channel.position((pos += entry.getCompressedSize()) - 1L);
                    if (pos > length || channel.position() >= channel.size()) {
                        throw new ZipException(entry.getName() + " (truncated entry data)");
                    }
                }
                catch (RuntimeException e) {
                    throw (ZipException)new ZipException(entry.getName() + " (invalid Local File Header or Data Descriptor)").initCause(e);
                }
            }
            this.postamble = length - channel.position();
            this.entries.put(entry.getName(), entry);
        }
        return this;
    }

    final Map<String, E> getRawEntries() {
        return this.entries;
    }

    private String decode(byte[] buffer) {
        return new String(buffer, this.charset);
    }

    @CheckForNull
    final byte[] getRawComment() {
        return this.comment;
    }

    @Nullable
    public String getComment() {
        byte[] comment = this.comment;
        return null == comment ? null : this.decode(comment);
    }

    public boolean busy() {
        return 0 < this.open;
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E entry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    public long length() {
        return this.length;
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    @CreatesObligation
    public InputStream getPreambleInputStream() throws IOException {
        return new ChannelInputStream((SeekableByteChannel)((Object)new EntryReadOnlyChannel(0L, this.preamble)));
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    @CreatesObligation
    public InputStream getPostambleInputStream() throws IOException {
        this.channel();
        return new ChannelInputStream((SeekableByteChannel)((Object)new EntryReadOnlyChannel(this.length - this.postamble, this.postamble)));
    }

    final PositionMapper getOffsetMapper() {
        return this.mapper;
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return 0L == this.mapper.map(0L);
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    @CreatesObligation
    @Nullable
    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, null, true);
    }

    @CreatesObligation
    @Nullable
    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    @CreatesObligation
    @Nullable
    protected InputStream getInputStream(String name, @CheckForNull Boolean check, boolean process) throws ZipException, IOException {
        ReadOnlyChannel echannel;
        SeekableByteChannel channel = this.channel();
        Objects.requireNonNull(name);
        ZipEntry entry = (ZipEntry)this.entries.get(name);
        if (null == entry) {
            return null;
        }
        long pos = entry.getOffset();
        assert (-1L != pos);
        pos = this.mapper.map(pos);
        MutableBuffer lfh = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)30).littleEndian()).load((ReadableByteChannel)channel.position(pos));
        if (67324752L != lfh.getUInt()) {
            throw new ZipException(name + " (expected local file header)");
        }
        lfh.position(26);
        pos += (long)(30 + lfh.getUShort() + lfh.getUShort());
        try {
            echannel = new EntryReadOnlyChannel(pos, entry.getCompressedSize());
        }
        catch (RuntimeException e) {
            throw (ZipException)new ZipException(name + " (invalid Local File Header, Data Descriptor or Central File Header)").initCause(e);
        }
        try {
            Object in;
            if (!process) {
                assert (-1L != entry.getCrc());
                return new ChannelInputStream((SeekableByteChannel)echannel);
            }
            if (null == check) {
                check = entry.isEncrypted();
            }
            int method = entry.getMethod();
            if (entry.isEncrypted()) {
                if (99 != method) {
                    throw new ZipException(name + " (encrypted compression method " + method + " is not supported)");
                }
                WinZipAesReadOnlyChannel eechannel = new WinZipAesReadOnlyChannel((SeekableByteChannel)echannel, new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), entry));
                echannel = eechannel;
                if (check.booleanValue()) {
                    eechannel.authenticate();
                    check = false;
                }
                WinZipAesExtraField field = (WinZipAesExtraField)entry.getExtraField(39169);
                method = field.getMethod();
            }
            if (check.booleanValue()) {
                long localCrc;
                if (entry.getGeneralPurposeBitFlag(8)) {
                    MutableBuffer dd = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate((int)8).littleEndian()).load((ReadableByteChannel)channel.position(pos + entry.getCompressedSize()));
                    localCrc = dd.getUInt();
                    if (134695760L == localCrc) {
                        localCrc = dd.getUInt();
                    }
                } else {
                    localCrc = ((MutableBuffer)lfh.position(14)).getUInt();
                }
                if (entry.getCrc() != localCrc) {
                    throw new Crc32Exception(name, entry.getCrc(), localCrc);
                }
            }
            int bufSize = AbstractZipFile.getBufferSize(entry);
            switch (method) {
                case 0: {
                    in = new ChannelInputStream((SeekableByteChannel)echannel);
                    break;
                }
                case 8: {
                    in = new ZipInflaterInputStream((InputStream)((Object)new DummyByteChannelInputStream((SeekableByteChannel)echannel)), bufSize);
                    break;
                }
                case 12: {
                    in = new BZip2CompressorInputStream((InputStream)new ChannelInputStream((SeekableByteChannel)echannel));
                    break;
                }
                default: {
                    throw new ZipException(name + " (compression method " + method + " is not supported)");
                }
            }
            if (check.booleanValue()) {
                in = new Crc32InputStream((InputStream)in, bufSize, entry);
            }
            return in;
        }
        catch (Throwable e1) {
            try {
                echannel.close();
            }
            catch (Throwable e2) {
                e1.addSuppressed(e2);
            }
            throw e1;
        }
    }

    private static int getBufferSize(ZipEntry entry) {
        long size = entry.getSize();
        if (8192L < size) {
            size = 8192L;
        } else if (size < 1024L) {
            size = 1024L;
        }
        return (int)size;
    }

    private SeekableByteChannel channel() throws ZipException {
        SeekableByteChannel channel = this.channel;
        if (null == channel) {
            throw new ZipException("File closed!");
        }
        return channel;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        SeekableByteChannel channel = this.channel;
        if (null != channel) {
            channel.close();
            this.channel = null;
        }
    }

    private static final class SafeBufferedReadOnlyChannel
    extends BufferedReadOnlyChannel {
        final long size;

        @CreatesObligation
        SafeBufferedReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel, long size) {
            super(channel);
            this.size = size;
        }

        public long size() throws IOException {
            this.checkOpen();
            return this.size;
        }
    }

    private final class EntryReadOnlyChannel
    extends ReadOnlyChannel {
        boolean closed;

        @CreatesObligation
        EntryReadOnlyChannel(long start, long size) throws IOException {
            super((SeekableByteChannel)new IntervalReadOnlyChannel(AbstractZipFile.this.channel(), start, size));
            AbstractZipFile.this.open++;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            AbstractZipFile.this.open--;
            this.closed = true;
        }
    }
}

