/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyManagerMap;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.ControlFlowException;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsCovariantNode;
import net.java.truevfs.kernel.spec.FsDecoratingController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncExceptionBuilder;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncWarningException;

@Immutable
public abstract class AbstractKeyController<D extends AbstractZipDriver<?>>
extends FsDecoratingController {
    private static final String ROOT_PATH = FsNodeName.ROOT.getPath();
    protected final D driver;
    private volatile KeyManagerMap container;

    protected AbstractKeyController(FsController controller, D driver) {
        super(controller);
        this.driver = (AbstractZipDriver)((Object)Objects.requireNonNull(driver));
    }

    protected abstract Class<?> getKeyType();

    protected abstract Class<? extends IOException> getKeyExceptionType();

    private KeyManager<?> getKeyManager() {
        KeyManagerMap c = this.container;
        return (null != c ? c : (this.container = ((AbstractZipDriver)((Object)this.driver)).getKeyManagerMap())).manager(this.getKeyType());
    }

    @CheckForNull
    private IOException findKeyException(Throwable ex) {
        Class<IOException> clazz = this.getKeyExceptionType();
        do {
            if (!clazz.isInstance(ex)) continue;
            return clazz.cast(ex);
        } while (null != (ex = ex.getCause()));
        return null;
    }

    public final FsNode node(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        try {
            return this.controller.node(options, name);
        }
        catch (ControlFlowException ex) {
            if (!name.isRoot() || null == this.findKeyException(ex)) {
                throw ex;
            }
            FsNode node = this.getParent().node(options, this.getModel().getMountPoint().getPath().resolve(name).getNodeName());
            if (null == node) {
                return null;
            }
            if (node instanceof FsCovariantNode) {
                node = ((FsCovariantNode)node).getEntry();
            }
            FsCovariantNode special = new FsCovariantNode(ROOT_PATH);
            special.put(Entry.Type.SPECIAL, this.driver.newEntry(ROOT_PATH, Entry.Type.SPECIAL, (Entry)node));
            return special;
        }
    }

    public void checkAccess(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types) throws IOException {
        try {
            this.controller.checkAccess(options, name, types);
        }
        catch (ControlFlowException ex) {
            if (!name.isRoot() || null == this.findKeyException(ex)) {
                throw ex;
            }
            this.getParent().checkAccess(options, this.getModel().getMountPoint().getPath().resolve(name).getNodeName(), types);
        }
    }

    public final void unlink(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        try {
            this.controller.unlink(options, name);
        }
        catch (ControlFlowException ex) {
            IOException keyEx = this.findKeyException(ex);
            if (null == keyEx) {
                throw ex;
            }
            throw keyEx;
        }
        FsModel model = this.getModel();
        URI mpu = ((AbstractZipDriver)((Object)this.driver)).mountPointUri(model);
        URI fsu = ((AbstractZipDriver)((Object)this.driver)).fileSystemUri(model, name.toString());
        if (!fsu.equals(mpu) || name.isRoot()) {
            this.getKeyManager().unlink(fsu);
        }
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        try {
            this.controller.sync(options);
        }
        catch (FsSyncWarningException ex) {
            builder.warn((Throwable)ex);
        }
        this.getKeyManager().release(((AbstractZipDriver)((Object)this.driver)).mountPointUri(this.getModel()));
        builder.check();
    }
}

