/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truevfs.driver.file.FileBuffer;
import net.java.truevfs.driver.file.FileNode;

@ThreadSafe
final class FileBufferPool
extends IoBufferPool {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final FileAttribute<?>[] ATTRIBUTES = FileBufferPool.isPosix() ? FileBufferPool.posixAttributes() : FileBufferPool.emptyAttributes();
    @Nullable
    private final Path dir;
    private final String prefix;

    private static boolean isPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static FileAttribute<?>[] posixAttributes() {
        return new FileAttribute[]{FileBufferPool.posixPermissions()};
    }

    private static FileAttribute<?>[] emptyAttributes() {
        return new FileAttribute[0];
    }

    private static FileAttribute<Set<PosixFilePermission>> posixPermissions() {
        return PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));
    }

    FileBufferPool() {
        this(null, null);
    }

    FileBufferPool(@CheckForNull Path dir, @CheckForNull String prefix) {
        this.dir = null != dir ? dir : TEMP_DIR;
        this.prefix = null != prefix ? FileBufferPool.prefixPlusDot(prefix) : "tvfs";
    }

    private static String prefixPlusDot(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public FileNode allocate() throws IOException {
        return new FileBuffer(this.createTempFile(), this);
    }

    private Path createTempFile() throws IOException {
        try {
            return Files.createTempFile(this.dir, this.prefix, null, FileBufferPool.attributes());
        }
        catch (IOException ex) {
            if (Files.exists(this.dir, new LinkOption[0])) {
                throw ex;
            }
            this.createTempDir();
            return this.createTempFile();
        }
    }

    private static FileAttribute<?>[] attributes() {
        return 0 == ATTRIBUTES.length ? ATTRIBUTES : (FileAttribute[])ATTRIBUTES.clone();
    }

    private void createTempDir() {
        assert (!Files.exists(this.dir, new LinkOption[0]));
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(this.dir + " (cannot create directory for temporary files)", ex);
        }
        assert (Files.exists(this.dir, new LinkOption[0]));
    }
}

