/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import net.java.truecommons.io.DecoratingSeekableChannel;

abstract class IOExceptionSeekableChannel
extends DecoratingSeekableChannel {
    @CheckForNull
    IOException exception;

    @CreatesObligation
    IOExceptionSeekableChannel(@WillCloseWhenClosed SeekableByteChannel channel) {
        super(channel);
    }

    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.channel.read(dst);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public int write(ByteBuffer src) throws IOException {
        try {
            return this.channel.write(src);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public long position() throws IOException {
        try {
            return this.channel.position();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public SeekableByteChannel position(long newPosition) throws IOException {
        try {
            this.channel.position(newPosition);
            return this;
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public long size() throws IOException {
        try {
            return this.channel.size();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public SeekableByteChannel truncate(long size) throws IOException {
        try {
            this.channel.truncate(size);
            return this;
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }
}

