/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.tar.xz;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.io.AbstractSink;
import net.java.truecommons.io.AbstractSource;
import net.java.truecommons.io.Sink;
import net.java.truecommons.io.Source;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.tardriver.FixedBufferedOutputStream;
import net.java.truevfs.comp.tardriver.TarDriver;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.comp.tardriver.TarInputService;
import net.java.truevfs.comp.tardriver.TarOutputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

@Immutable
public class TarXZDriver
extends TarDriver {
    public int getBufferSize() {
        return 8192;
    }

    public int getPreset() {
        return 6;
    }

    protected InputService<TarDriverEntry> newInput(FsModel model, final FsInputSocketSource source) throws IOException {
        final class Source
        extends AbstractSource {
            Source() {
            }

            public InputStream stream() throws IOException {
                InputStream in = source.stream();
                try {
                    return new XZInputStream((InputStream)new BufferedInputStream(in, TarXZDriver.this.getBufferSize()));
                }
                catch (Throwable ex) {
                    try {
                        in.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new TarInputService(model, (net.java.truecommons.io.Source)new Source(), (TarDriver)this);
    }

    protected OutputService<TarDriverEntry> newOutput(FsModel model, final FsOutputSocketSink sink, InputService<TarDriverEntry> input) throws IOException {
        final class Sink
        extends AbstractSink {
            Sink() {
            }

            public OutputStream stream() throws IOException {
                OutputStream out = sink.stream();
                try {
                    return new FixedXZOutputStream(new FixedBufferedOutputStream(out, TarXZDriver.this.getBufferSize()), new LZMA2Options(TarXZDriver.this.getPreset()));
                }
                catch (Throwable ex) {
                    try {
                        out.close();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new MultiplexingOutputService(this.getPool(), (OutputService)new TarOutputService(model, (net.java.truecommons.io.Sink)new Sink(), (TarDriver)this));
    }

    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller, FsNodeName name) {
        options = options.set((Enum)FsAccessOption.STORE);
        return new FsOutputSocketSink(options, controller.output(options, name, null));
    }

    private static final class FixedXZOutputStream
    extends XZOutputStream {
        final FixedBufferedOutputStream out;

        private FixedXZOutputStream(FixedBufferedOutputStream out, LZMA2Options options) throws IOException {
            super((OutputStream)out, (FilterOptions)options);
            this.out = out;
        }

        public void close() throws IOException {
            this.out.setIgnoreClose(true);
            super.close();
            this.out.setIgnoreClose(false);
            this.out.close();
        }
    }
}

