/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes.crypto;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.Sink;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersException;
import net.java.truevfs.driver.zip.raes.crypto.RaesParametersProvider;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesOutputStream;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import org.bouncycastle.crypto.Mac;

@NotThreadSafe
public abstract class RaesOutputStream
extends DecoratingOutputStream {
    public abstract KeyStrength getKeyStrength();

    static void klac(Mac klac, long length, byte[] buf) {
        for (int i = 0; i < 8; ++i) {
            klac.update((byte)length);
            length >>= 8;
        }
        int bufLength = klac.doFinal(buf, 0);
        assert (bufLength == buf.length);
    }

    @CreatesObligation
    public static RaesOutputStream create(RaesParameters param, Sink sink) throws RaesParametersException, IOException {
        RaesParameters p = param;
        while (null != p) {
            if (p instanceof Type0RaesParameters) {
                return new Type0RaesOutputStream((Type0RaesParameters)p, sink);
            }
            if (!(p instanceof RaesParametersProvider)) break;
            p = ((RaesParametersProvider)p).get(RaesParameters.class);
        }
        throw new RaesParametersException("Unknown RAES parameter type: " + param.getClass());
    }
}

