/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.FsUriModifier;

@Immutable
@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public final class FsMountPoint
implements Serializable,
Comparable<FsMountPoint> {
    private static final long serialVersionUID = 5723957985634276648L;
    public static final String SEPARATOR = "!/";
    @SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private URI uri;
    @Nullable
    private transient FsNodePath path;
    @Nullable
    private volatile transient FsScheme scheme;
    @Nullable
    private volatile transient URI hierarchical;

    public static FsMountPoint create(URI uri) {
        return FsMountPoint.create(uri, FsUriModifier.NULL);
    }

    public static FsMountPoint create(URI uri, FsUriModifier modifier) {
        try {
            return new FsMountPoint(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsMountPoint create(FsScheme scheme, FsNodePath path) {
        try {
            return new FsMountPoint(scheme, path);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @ConstructorProperties(value={"uri"})
    public FsMountPoint(URI uri) throws URISyntaxException {
        this.parse(uri, FsUriModifier.NULL);
    }

    public FsMountPoint(URI uri, FsUriModifier modifier) throws URISyntaxException {
        this.parse(uri, modifier);
    }

    public FsMountPoint(FsScheme scheme, FsNodePath path) throws URISyntaxException {
        URI pu = path.getUri();
        if (!pu.isAbsolute()) {
            throw new QuotedUriSyntaxException((Object)pu, "Path not absolute");
        }
        String penup = path.getNodeName().getUri().getPath();
        if (0 == penup.length()) {
            throw new QuotedUriSyntaxException((Object)pu, "Empty node name");
        }
        this.uri = new UriBuilder(true).scheme(scheme.toString()).path(pu.getScheme() + ':' + pu.getRawSchemeSpecificPart() + SEPARATOR).toUri();
        this.scheme = scheme;
        this.path = path;
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()), FsUriModifier.NULL);
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri, FsUriModifier modifier) throws URISyntaxException {
        if (null != (uri = modifier.modify(uri, FsUriModifier.PostFix.MOUNT_POINT)).getRawQuery()) {
            throw new QuotedUriSyntaxException((Object)uri, "Query component not allowed");
        }
        if (null != uri.getRawFragment()) {
            throw new QuotedUriSyntaxException((Object)uri, "Fragment component not allowed");
        }
        if (uri.isOpaque()) {
            URI nuri;
            String ssp = uri.getRawSchemeSpecificPart();
            int i = ssp.lastIndexOf(SEPARATOR);
            if (ssp.length() - 2 != i) {
                throw new QuotedUriSyntaxException((Object)uri, "Doesn't end with mount point separator \"!/\"");
            }
            this.path = new FsNodePath(new URI(ssp.substring(0, i)), modifier);
            URI pu = this.path.getUri();
            if (!pu.isAbsolute()) {
                throw new QuotedUriSyntaxException((Object)uri, "Path not absolute");
            }
            if (0 == this.path.getNodeName().getPath().length()) {
                throw new QuotedUriSyntaxException((Object)uri, "Empty URI path of node name of node path");
            }
            if (FsUriModifier.NULL != modifier && !uri.equals(nuri = new UriBuilder(true).scheme(uri.getScheme()).path(pu.getScheme() + ':' + pu.getRawSchemeSpecificPart() + SEPARATOR).toUri())) {
                uri = nuri;
            }
        } else {
            if (!uri.isAbsolute()) {
                throw new QuotedUriSyntaxException((Object)uri, "Not absolute");
            }
            if (!uri.getRawPath().endsWith("/")) {
                throw new QuotedUriSyntaxException((Object)uri, "Path component doesn't end with separator \"/\"");
            }
            this.path = null;
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (this.getUri().isAbsolute());
        assert (null == this.getUri().getRawQuery());
        assert (null == this.getUri().getRawFragment());
        if (this.getUri().isOpaque()) {
            assert (this.getUri().getRawSchemeSpecificPart().endsWith(SEPARATOR));
            FsNodePath path = this.getPath();
            assert (null != path);
            assert (path.getUri().isAbsolute());
            assert (null == path.getUri().getRawFragment());
            assert (0 != path.getNodeName().getUri().getRawPath().length());
        } else {
            assert (this.getUri().normalize() == this.getUri());
            assert (this.getUri().getRawPath().endsWith("/"));
            assert (null == this.getPath());
        }
        return true;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI toHierarchicalUri() {
        URI hierarchical = this.hierarchical;
        return null != hierarchical ? hierarchical : (this.hierarchical = this.uri.isOpaque() ? this.path.toHierarchicalUri() : this.uri);
    }

    public FsScheme getScheme() {
        FsScheme scheme = this.scheme;
        return null != scheme ? scheme : (this.scheme = FsScheme.create(this.uri.getScheme()));
    }

    @Nullable
    public FsNodePath getPath() {
        return this.path;
    }

    @Nullable
    public FsMountPoint getParent() {
        assert (null == this.path || null != this.path.getMountPoint());
        return null == this.path ? null : this.path.getMountPoint();
    }

    public FsNodePath resolve(FsNodeName name) {
        return new FsNodePath(this, name);
    }

    @Override
    public int compareTo(FsMountPoint that) {
        return this.uri.compareTo(that.uri);
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsMountPoint && this.uri.equals(((FsMountPoint)that).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

