/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Objects;
import javax.inject.Provider;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncExceptionBuilder;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

public final class FsSync {
    private Provider<FsManager> managerProvider = FsManagerLocator.SINGLETON;
    private Filter<? super FsController> filter = Filter.ACCEPT_ANY;
    private BitField<FsSyncOption> options = FsSyncOptions.NONE;

    public FsSync manager(final FsManager manager) {
        Objects.requireNonNull(manager);
        this.managerProvider = new Provider<FsManager>(){

            public FsManager get() {
                return manager;
            }
        };
        return this;
    }

    public FsSync filter(Filter<? super FsController> filter) {
        this.filter = Objects.requireNonNull(filter);
        return this;
    }

    public FsSync options(BitField<FsSyncOption> options) {
        this.options = Objects.requireNonNull(options);
        return this;
    }

    public void run() throws FsSyncException {
        final class SyncVisitor
        implements Visitor<FsController, RuntimeException> {
            final FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();

            SyncVisitor() {
            }

            public void visit(FsController controller) {
                try {
                    controller.sync((BitField<FsSyncOption>)FsSync.this.options);
                }
                catch (FsSyncException e) {
                    this.builder.warn(e);
                }
            }

            void check() throws FsSyncException {
                this.builder.check();
            }
        }
        this.manager().accept(this.filter, new SyncVisitor()).check();
    }

    private FsManager manager() {
        return (FsManager)this.managerProvider.get();
    }
}

