/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.tardriver;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.AbstractInputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.Source;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.HashMaps;
import net.java.truecommons.shed.SuppressedExceptionBuilder;
import net.java.truevfs.comp.tardriver.TarDriver;
import net.java.truevfs.comp.tardriver.TarDriverEntry;
import net.java.truevfs.comp.tardriver.TarException;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsModel;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarUtils;

@NotThreadSafe
public final class TarInputService
implements InputService<TarDriverEntry> {
    private static final byte[] NULL_RECORD = new byte[512];
    private static final int CHECKSUM_OFFSET = 148;
    private final Map<String, TarDriverEntry> entries = new LinkedHashMap<String, TarDriverEntry>(HashMaps.initialCapacity(47));
    private final TarDriver driver;

    @CreatesObligation
    public TarInputService(FsModel model, Source source, TarDriver driver) throws EOFException, IOException {
        Objects.requireNonNull(model);
        this.driver = Objects.requireNonNull(driver);
        try (InputStream in = source.stream();){
            try {
                this.unpack(this.newValidatedTarArchiveInputStream(in));
            }
            catch (Throwable ex) {
                try {
                    this.close0();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
        }
    }

    private void unpack(@WillNotClose TarArchiveInputStream tain) throws IOException {
        TarArchiveEntry tinEntry;
        TarDriver driver = this.driver;
        IoBufferPool pool = driver.getPool();
        while (null != (tinEntry = tain.getNextTarEntry())) {
            String name = TarInputService.name(tinEntry);
            TarDriverEntry entry2 = this.entries.get(name);
            if (null != entry2) {
                entry2.release();
            }
            entry2 = driver.newEntry(name, tinEntry);
            if (!tinEntry.isDirectory()) {
                IoBuffer buffer = (IoBuffer)pool.allocate();
                entry2.setBuffer(buffer);
                try (OutputStream out = buffer.output().stream(null);){
                    Streams.cat(tain, out);
                }
                catch (Throwable ex) {
                    try {
                        buffer.release();
                    }
                    catch (Throwable ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
            this.entries.put(name, entry2);
        }
    }

    private static String name(TarArchiveEntry entry2) {
        String name = entry2.getName();
        Entry.Type type = entry2.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
        return FsArchiveDriver.normalize(name, type);
    }

    private TarArchiveInputStream newValidatedTarArchiveInputStream(@WillNotClose InputStream in) throws EOFException, IOException {
        byte[] buf = new byte[512];
        InputStream vin = TarInputService.readAhead(in, buf);
        if (!Arrays.equals(buf, NULL_RECORD)) {
            long expected;
            try {
                expected = TarUtils.parseOctal(buf, 148, 8);
            }
            catch (IllegalArgumentException ex) {
                throw new TarException("Invalid initial record in TAR file!", ex);
            }
            for (int i = 0; i < 8; ++i) {
                buf[148 + i] = 32;
            }
            long actual = TarUtils.computeCheckSum(buf);
            if (expected != actual) {
                throw new TarException("Invalid initial record in TAR file: Expected / actual checksum : " + expected + " / " + actual + "!");
            }
        }
        return new TarArchiveInputStream(vin, 10240, 512, this.driver.getEncoding());
    }

    private static InputStream readAhead(@WillNotClose InputStream in, byte[] buf) throws EOFException, IOException {
        if (in.markSupported()) {
            in.mark(buf.length);
            new DataInputStream(in).readFully(buf);
            in.reset();
            return in;
        }
        PushbackInputStream pin = new PushbackInputStream(in, buf.length);
        new DataInputStream(pin).readFully(buf);
        pin.unread(buf);
        return pin;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<TarDriverEntry> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    @Override
    @CheckForNull
    public TarDriverEntry entry(String name) {
        return this.entries.get(name);
    }

    @Override
    public InputSocket<TarDriverEntry> input(final String name) {
        Objects.requireNonNull(name);
        final class Input
        extends AbstractInputSocket<TarDriverEntry> {
            Input() {
            }

            @Override
            public TarDriverEntry target() throws IOException {
                TarDriverEntry entry2 = TarInputService.this.entry(name);
                if (null == entry2) {
                    throw new NoSuchFileException(name, null, "Entry not found!");
                }
                if (entry2.isDirectory()) {
                    throw new NoSuchFileException(name, null, "Cannot read directory entries!");
                }
                return entry2;
            }

            @Override
            public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
                return this.socket().stream(peer);
            }

            @Override
            public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
                return this.socket().channel(peer);
            }

            InputSocket<? extends IoBuffer> socket() throws IOException {
                return this.target().getBuffer().input();
            }
        }
        return new Input();
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        SuppressedExceptionBuilder builder = new SuppressedExceptionBuilder();
        Iterator<TarDriverEntry> i = this.entries.values().iterator();
        while (i.hasNext()) {
            try {
                i.next().release();
            }
            catch (IOException ex) {
                builder.warn(ex);
            }
            i.remove();
        }
        builder.check();
    }
}

