/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.UShort;

@NotThreadSafe
final class DefaultExtraField
extends ExtraField {
    private final short headerId;
    @CheckForNull
    private byte[] data;

    DefaultExtraField(int headerId) {
        assert (UShort.check(headerId));
        this.headerId = (short)headerId;
    }

    @Override
    int getHeaderId() {
        return this.headerId & 0xFFFF;
    }

    @Override
    int getDataSize() {
        byte[] data2 = this.data;
        return null != data2 ? data2.length : 0;
    }

    @Override
    void readFrom(byte[] buf, int off, int len) {
        assert (UShort.check(len));
        this.data = new byte[len];
        System.arraycopy(buf, off, this.data, 0, len);
    }

    @Override
    void writeTo(byte[] buf, int off) {
        byte[] src = this.data;
        if (null != src) {
            System.arraycopy(src, 0, buf, off, src.length);
        }
    }
}

