/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import net.java.truecommons.shed.Filter;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsMountPoint;

public final class FsControllerFilter
implements Filter<FsController> {
    private final String ps;
    private final String pp;
    private final int ppl;
    private final boolean pps;

    public FsControllerFilter(FsMountPoint prefix) {
        URI p = prefix.toHierarchicalUri();
        this.ps = p.getScheme();
        this.pp = p.getPath();
        this.ppl = this.pp.length();
        this.pps = '/' == this.pp.charAt(this.ppl - 1);
    }

    @Override
    public boolean accept(FsController controller2) {
        String mpp;
        URI mp = controller2.getModel().getMountPoint().toHierarchicalUri();
        return mp.getScheme().equals(this.ps) && (mpp = mp.getPath()).startsWith(this.pp) && (this.pps || mpp.length() == this.ppl || '/' == mpp.charAt(this.ppl));
    }
}

