/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;

public class JsonFluentAssert {
    private static final String ACTUAL = "actual";
    private final String path;
    private final Object actual;
    private final String description;
    private final Configuration configuration;

    protected JsonFluentAssert(Object actual, String path, String description, Configuration configuration) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
    }

    protected JsonFluentAssert(Object actual) {
        this(actual, "", "", Configuration.empty());
    }

    public static JsonFluentAssert assertThatJson(Object json) {
        return new JsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public void isStringEqualTo(String expected) {
        this.isString();
        Node node = JsonUtils.getNode((Object)this.actual, (String)this.path);
        if (!node.asText().equals(expected)) {
            this.failWithMessage("Node \"" + this.path + "\" is not equal to \"" + expected + "\".");
        }
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    public JsonFluentAssert hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonFluentAssert node(String path) {
        return new JsonFluentAssert(this.actual, path, this.description, this.configuration);
    }

    private Diff createDiff(Object expected, Configuration configuration) {
        return Diff.create((Object)expected, (Object)this.actual, (String)ACTUAL, (String)this.path, (Configuration)configuration);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonFluentAssert describedAs(String description) {
        return new JsonFluentAssert(this.actual, this.path, description, this.configuration);
    }

    public JsonFluentAssert ignoring(String ignorePlaceholder) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public JsonFluentAssert withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public JsonFluentAssert withTolerance(BigDecimal tolerance) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
    }

    @Deprecated
    public JsonFluentAssert treatingNullAsAbsent() {
        return this.when(Option.TREATING_NULL_AS_ABSENT, new Option[0]);
    }

    public JsonFluentAssert when(Option firstOption, Option ... otherOptions) {
        return new JsonFluentAssert(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
    }

    public JsonFluentAssert isAbsent() {
        if (JsonUtils.nodeExists((Object)this.actual, (String)this.path)) {
            this.failWithMessage("Node \"" + this.path + "\" is present.");
        }
        return this;
    }

    public JsonFluentAssert isPresent() {
        if (!JsonUtils.nodeExists((Object)this.actual, (String)this.path)) {
            this.failWithMessage("Node \"" + this.path + "\" is missing.");
        }
        return this;
    }

    public ArrayAssert isArray() {
        this.isPresent();
        Node node = JsonUtils.getNode((Object)this.actual, (String)this.path);
        if (node.getNodeType() != Node.NodeType.ARRAY) {
            this.failOnType(node, "an array");
        }
        return new ArrayAssert(node.arrayElements());
    }

    public void isObject() {
        this.isPresent();
        Node node = JsonUtils.getNode((Object)this.actual, (String)this.path);
        if (node.getNodeType() != Node.NodeType.OBJECT) {
            this.failOnType(node, "an object");
        }
    }

    public void isString() {
        this.isPresent();
        Node node = JsonUtils.getNode((Object)this.actual, (String)this.path);
        if (node.getNodeType() != Node.NodeType.STRING) {
            this.failOnType(node, "a string");
        }
    }

    private void failOnType(Node node, String type) {
        this.failWithMessage("Node \"" + this.path + "\" is not " + type + ". The actual value is '" + node + "'.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArrayAssert {
        private final List<Node> array;

        public ArrayAssert(Iterator<Node> array) {
            ArrayList<Node> list = new ArrayList<Node>();
            while (array.hasNext()) {
                list.add(array.next());
            }
            this.array = list;
        }

        public ArrayAssert ofLength(int expectedLength) {
            if (this.array.size() != expectedLength) {
                JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" length is " + this.array.size() + ", expected length is " + expectedLength + ".");
            }
            return this;
        }
    }
}

