/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final Configuration configuration;
    final Function<Object, Object> jsonTransformer;

    AbstractSpringMatchers(@NotNull Configuration configuration, Function<Object, Object> jsonTransformer) {
        this.configuration = configuration;
        this.jsonTransformer = jsonTransformer;
    }

    @NotNull
    abstract MATCHER matcher(@NotNull Consumer<InternalMatcher> var1);

    @NotNull
    abstract ME matchers(@NotNull Configuration var1, @NotNull Function<Object, Object> var2);

    protected ME matchers(@NotNull Configuration configuration) {
        return this.matchers(configuration, this.jsonTransformer);
    }

    @NotNull
    public ME node(String path) {
        return this.inPath(path);
    }

    @NotNull
    public ME inPath(String path) {
        return this.matchers(this.configuration, json -> JsonPathAdapter.inPath((Object)this.jsonTransformer.apply(json), (String)path));
    }

    @NotNull
    public ME ignoring(@NotNull String ignorePlaceholder) {
        return this.matchers(this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    @NotNull
    public ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    @NotNull
    public ME withMatcher(@NotNull String matcherName, @NotNull Matcher<?> matcher) {
        return this.matchers(this.configuration.withMatcher(matcherName, matcher));
    }

    @NotNull
    public ME withTolerance(@Nullable BigDecimal tolerance) {
        return this.matchers(this.configuration.withTolerance(tolerance));
    }

    @NotNull
    public ME withDifferenceListener(@NotNull DifferenceListener differenceListener) {
        return this.matchers(this.configuration.withDifferenceListener(differenceListener));
    }

    @NotNull
    public ME when(@NotNull Option firstOption, Option ... otherOptions) {
        return this.matchers(this.configuration.withOptions(firstOption, otherOptions));
    }

    @NotNull
    public ME when(@NotNull ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        return this.matchers(this.configuration.when(object, actions));
    }

    @NotNull
    public MATCHER isEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isEqualTo(expected));
    }

    @NotNull
    public MATCHER isStringEqualTo(@Nullable String expected) {
        return this.matcher(ctx -> ctx.isStringEqualTo(expected));
    }

    @NotNull
    public MATCHER isNotEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isNotEqualTo(expected));
    }

    @NotNull
    public MATCHER isAbsent() {
        return this.matcher(ctx -> ctx.isAbsent());
    }

    @NotNull
    public MATCHER isPresent() {
        return this.matcher(InternalMatcher::isPresent);
    }

    @NotNull
    public MATCHER isArray() {
        return this.matcher(InternalMatcher::isArray);
    }

    @NotNull
    public MATCHER isObject() {
        return this.matcher(InternalMatcher::isObject);
    }

    @NotNull
    public MATCHER isString() {
        return this.matcher(InternalMatcher::isString);
    }

    @NotNull
    public MATCHER isNull() {
        return this.matcher(InternalMatcher::isNull);
    }

    @NotNull
    public MATCHER isNotNull() {
        return this.matcher(InternalMatcher::isNotNull);
    }

    @NotNull
    public MATCHER matches(@NotNull Matcher<?> matcher) {
        return this.matcher(ctx -> ctx.matches(matcher));
    }

    @NotNull
    public MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    @NotNull
    public MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

