/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.micronaut.internal;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.micronaut.SchedulerLock;

class MicronautLockConfigurationExtractor {
    private final Duration defaultLockAtMostFor;
    private final Duration defaultLockAtLeastFor;
    private final ConversionService<?> conversionService;

    MicronautLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor, ConversionService<?> conversionService) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.conversionService = conversionService;
    }

    Optional<LockConfiguration> getLockConfiguration(ExecutableMethod<Object, Object> method) {
        Optional<AnnotationValue<SchedulerLock>> annotation = this.findAnnotation(method);
        return annotation.map(this::getLockConfiguration);
    }

    private LockConfiguration getLockConfiguration(AnnotationValue<SchedulerLock> annotation) {
        return new LockConfiguration(ClockProvider.now(), this.getName(annotation), this.getLockAtMostFor(annotation), this.getLockAtLeastFor(annotation));
    }

    private String getName(AnnotationValue<SchedulerLock> annotation) {
        return (String)annotation.getRequiredValue("name", String.class);
    }

    Duration getLockAtMostFor(AnnotationValue<SchedulerLock> annotation) {
        return this.getValue(annotation, this.defaultLockAtMostFor, "lockAtMostFor");
    }

    Duration getLockAtLeastFor(AnnotationValue<SchedulerLock> annotation) {
        return this.getValue(annotation, this.defaultLockAtLeastFor, "lockAtLeastFor");
    }

    private Duration getValue(AnnotationValue<SchedulerLock> annotation, Duration defaultValue, String paramName) {
        String stringValueFromAnnotation = annotation.get((CharSequence)paramName, String.class).orElse("");
        if (StringUtils.hasText((CharSequence)stringValueFromAnnotation)) {
            return (Duration)this.conversionService.convert((Object)stringValueFromAnnotation, Duration.class).orElseThrow(() -> new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into duration"));
        }
        return defaultValue;
    }

    Optional<AnnotationValue<SchedulerLock>> findAnnotation(ExecutableMethod<Object, Object> method) {
        return method.findAnnotation(SchedulerLock.class);
    }
}

