/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Objects;
import net.javacrumbs.shedlock.provider.cassandra.CassandraStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import net.javacrumbs.shedlock.support.annotation.Nullable;

public class CassandraLockProvider
extends StorageBasedLockProvider {
    static final String DEFAULT_TABLE = "lock";

    public CassandraLockProvider(CqlSession cqlSession) {
        this(cqlSession, DEFAULT_TABLE, ConsistencyLevel.QUORUM);
    }

    public CassandraLockProvider(CqlSession cqlSession, String table, ConsistencyLevel consistencyLevel) {
        this(Configuration.builder().withCqlSession(cqlSession).withTableName(table).withConsistencyLevel(consistencyLevel).build());
    }

    public CassandraLockProvider(Configuration configuration) {
        super((StorageAccessor)new CassandraStorageAccessor(configuration));
    }

    public static final class Configuration {
        private final CqlIdentifier table;
        private final ColumnNames columnNames;
        private final CqlSession cqlSession;
        @Nullable
        private final ConsistencyLevel consistencyLevel;
        @Nullable
        private final ConsistencyLevel serialConsistencyLevel;
        @Nullable
        private final CqlIdentifier keyspace;

        Configuration(CqlSession cqlSession, CqlIdentifier table, ColumnNames columnNames, @Nullable ConsistencyLevel consistencyLevel, @Nullable ConsistencyLevel serialConsistencyLevel, @Nullable CqlIdentifier keyspace) {
            this.table = Objects.requireNonNull(table, "table can not be null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames can not be null");
            this.cqlSession = Objects.requireNonNull(cqlSession, "cqlSession can not be null");
            this.consistencyLevel = Objects.requireNonNull(consistencyLevel, "consistencyLevel can not be null");
            this.serialConsistencyLevel = Objects.requireNonNull(serialConsistencyLevel, "serialConsistencyLevel can not be null");
            this.keyspace = keyspace;
        }

        public ColumnNames getColumnNames() {
            return this.columnNames;
        }

        public CqlIdentifier getTable() {
            return this.table;
        }

        public CqlSession getCqlSession() {
            return this.cqlSession;
        }

        @Nullable
        public ConsistencyLevel getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Nullable
        public ConsistencyLevel getSerialConsistencyLevel() {
            return this.serialConsistencyLevel;
        }

        @Nullable
        public CqlIdentifier getKeyspace() {
            return this.keyspace;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private CqlIdentifier table = CqlIdentifier.fromCql((String)"lock");
            private ColumnNames columnNames = new ColumnNames("name", "lockUntil", "lockedAt", "lockedBy");
            private CqlSession cqlSession;
            @Nullable
            private ConsistencyLevel consistencyLevel = ConsistencyLevel.QUORUM;
            @Nullable
            private ConsistencyLevel serialConsistencyLevel = ConsistencyLevel.SERIAL;
            @Nullable
            private CqlIdentifier keyspace;

            public Builder withTableName(String table) {
                return this.withTableName(CqlIdentifier.fromCql((String)table));
            }

            public Builder withTableName(CqlIdentifier table) {
                this.table = table;
                return this;
            }

            public Builder withColumnNames(ColumnNames columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            public Builder withCqlSession(CqlSession cqlSession) {
                this.cqlSession = cqlSession;
                return this;
            }

            public Builder withConsistencyLevel(ConsistencyLevel consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            public Builder withSerialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
                this.serialConsistencyLevel = serialConsistencyLevel;
                return this;
            }

            public Builder withKeyspace(CqlIdentifier keyspace) {
                this.keyspace = keyspace;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.cqlSession, this.table, this.columnNames, this.consistencyLevel, this.serialConsistencyLevel, this.keyspace);
            }
        }
    }

    public static final class ColumnNames {
        private final String lockName;
        private final String lockUntil;
        private final String lockedAt;
        private final String lockedBy;

        public ColumnNames(String lockName, String lockUntil, String lockedAt, String lockedBy) {
            this.lockName = Objects.requireNonNull(lockName, "'lockName' column name can not be null");
            this.lockUntil = Objects.requireNonNull(lockUntil, "'lockUntil' column name can not be null");
            this.lockedAt = Objects.requireNonNull(lockedAt, "'lockedAt' column name can not be null");
            this.lockedBy = Objects.requireNonNull(lockedBy, "'lockedBy' column name can not be null");
        }

        public String getLockName() {
            return this.lockName;
        }

        public String getLockUntil() {
            return this.lockUntil;
        }

        public String getLockedAt() {
            return this.lockedAt;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }
    }
}

