/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.servererrors.QueryExecutionException;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.cassandra.CassandraLockProvider;
import net.javacrumbs.shedlock.provider.cassandra.Lock;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.Nullable;

class CassandraStorageAccessor
extends AbstractStorageAccessor {
    private final String hostname;
    private final CqlIdentifier table;
    @Nullable
    private final CqlIdentifier keyspace;
    private final String lockName;
    private final String lockUntil;
    private final String lockedAt;
    private final String lockedBy;
    private final CqlSession cqlSession;
    @Nullable
    private final ConsistencyLevel consistencyLevel;
    @Nullable
    private final ConsistencyLevel serialConsistencyLevel;

    CassandraStorageAccessor(CassandraLockProvider.Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration can not be null");
        this.hostname = Utils.getHostname();
        this.table = configuration.getTable();
        this.keyspace = configuration.getKeyspace();
        this.lockName = configuration.getColumnNames().getLockName();
        this.lockUntil = configuration.getColumnNames().getLockUntil();
        this.lockedAt = configuration.getColumnNames().getLockedAt();
        this.lockedBy = configuration.getColumnNames().getLockedBy();
        this.cqlSession = configuration.getCqlSession();
        this.consistencyLevel = configuration.getConsistencyLevel();
        this.serialConsistencyLevel = configuration.getSerialConsistencyLevel();
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        if (this.find(lockConfiguration.getName()).isPresent()) {
            return false;
        }
        try {
            return this.insert(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
        }
        catch (QueryExecutionException e) {
            this.logger.warn("Error on insert", (Throwable)e);
            return false;
        }
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        Optional<Lock> lock = this.find(lockConfiguration.getName());
        if (lock.isEmpty() || lock.get().lockUntil().isAfter(ClockProvider.now())) {
            return false;
        }
        try {
            return this.update(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
        }
        catch (QueryExecutionException e) {
            this.logger.warn("Error on update", (Throwable)e);
            return false;
        }
    }

    public void unlock(LockConfiguration lockConfiguration) {
        this.updateUntil(lockConfiguration.getName(), lockConfiguration.getUnlockTime());
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        Optional<Lock> lock = this.find(lockConfiguration.getName());
        if (lock.isEmpty() || lock.get().lockUntil().isBefore(ClockProvider.now()) || !lock.get().lockedBy().equals(this.hostname)) {
            this.logger.trace("extend false");
            return false;
        }
        return this.updateUntil(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
    }

    Optional<Lock> find(String name) {
        SimpleStatement selectStatement = (SimpleStatement)((SimpleStatement)((Select)QueryBuilder.selectFrom((CqlIdentifier)this.keyspace, (CqlIdentifier)this.table).column(this.lockUntil).column(this.lockedAt).column(this.lockedBy).whereColumn(this.lockName).isEqualTo((Term)QueryBuilder.literal((Object)name))).build().setConsistencyLevel(this.consistencyLevel)).setSerialConsistencyLevel(this.serialConsistencyLevel);
        ResultSet resultSet = this.cqlSession.execute((Statement)selectStatement);
        Row row = (Row)resultSet.one();
        if (row != null) {
            return Optional.of(new Lock(row.getInstant(this.lockUntil), row.getInstant(this.lockedAt), row.getString(this.lockedBy)));
        }
        return Optional.empty();
    }

    private boolean insert(String name, Instant until) {
        return this.execute(QueryBuilder.insertInto((CqlIdentifier)this.keyspace, (CqlIdentifier)this.table).value(this.lockName, (Term)QueryBuilder.literal((Object)name)).value(this.lockUntil, (Term)QueryBuilder.literal((Object)until)).value(this.lockedAt, (Term)QueryBuilder.literal((Object)ClockProvider.now())).value(this.lockedBy, (Term)QueryBuilder.literal((Object)this.hostname)).ifNotExists().build());
    }

    private boolean update(String name, Instant until) {
        return this.execute(((Update)((Update)QueryBuilder.update((CqlIdentifier)this.keyspace, (CqlIdentifier)this.table).setColumn(this.lockUntil, (Term)QueryBuilder.literal((Object)until)).setColumn(this.lockedAt, (Term)QueryBuilder.literal((Object)ClockProvider.now())).setColumn(this.lockedBy, (Term)QueryBuilder.literal((Object)this.hostname)).whereColumn(this.lockName).isEqualTo((Term)QueryBuilder.literal((Object)name))).ifColumn(this.lockUntil).isLessThan((Term)QueryBuilder.literal((Object)ClockProvider.now()))).build());
    }

    private boolean updateUntil(String name, Instant until) {
        return this.execute(((Update)((Update)((Update)QueryBuilder.update((CqlIdentifier)this.keyspace, (CqlIdentifier)this.table).setColumn(this.lockUntil, (Term)QueryBuilder.literal((Object)until)).whereColumn(this.lockName).isEqualTo((Term)QueryBuilder.literal((Object)name))).ifColumn(this.lockUntil).isGreaterThanOrEqualTo((Term)QueryBuilder.literal((Object)ClockProvider.now()))).ifColumn(this.lockedBy).isEqualTo((Term)QueryBuilder.literal((Object)this.hostname))).build());
    }

    private boolean execute(SimpleStatement statement) {
        return this.cqlSession.execute(((SimpleStatement)statement.setConsistencyLevel(this.consistencyLevel)).setSerialConsistencyLevel(this.serialConsistencyLevel)).wasApplied();
    }
}

