/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;

public class DynamoDBLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    private static final String OBTAIN_LOCK_QUERY = "set lockUntil = :lockUntil, lockedAt = :lockedAt, lockedBy = :lockedBy";
    private static final String OBTAIN_LOCK_CONDITION = "lockUntil <= :lockedAt or attribute_not_exists(lockUntil)";
    private static final String RELEASE_LOCK_QUERY = "set lockUntil = :lockUntil";
    private final String hostname;
    private final Table table;

    public DynamoDBLockProvider(Table table) {
        this.table = table;
        this.hostname = Utils.getHostname();
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        String nowIso = Utils.toIsoString((Instant)this.now());
        String lockUntilIso = Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil());
        UpdateItemSpec request = new UpdateItemSpec().withPrimaryKey(ID, (Object)lockConfiguration.getName()).withUpdateExpression(OBTAIN_LOCK_QUERY).withConditionExpression(OBTAIN_LOCK_CONDITION).withValueMap((Map)new ValueMap().withString(":lockUntil", lockUntilIso).withString(":lockedAt", nowIso).withString(":lockedBy", this.hostname)).withReturnValues(ReturnValue.UPDATED_NEW);
        try {
            UpdateItemOutcome updated = this.table.updateItem(request);
            assert (lockUntilIso.equals(updated.getItem().getString(LOCK_UNTIL)));
            return Optional.of(new DynamoDBLock(lockConfiguration));
        }
        catch (ConditionalCheckFailedException e) {
            return Optional.empty();
        }
    }

    private Instant now() {
        return Instant.now();
    }

    private final class DynamoDBLock
    implements SimpleLock {
        private final LockConfiguration lockConfiguration;

        private DynamoDBLock(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
        }

        public void unlock() {
            String unlockTimeIso = Utils.toIsoString((Instant)this.lockConfiguration.getUnlockTime());
            UpdateItemSpec request = new UpdateItemSpec().withPrimaryKey(DynamoDBLockProvider.ID, (Object)this.lockConfiguration.getName()).withUpdateExpression(DynamoDBLockProvider.RELEASE_LOCK_QUERY).withValueMap((Map)new ValueMap().withString(":lockUntil", unlockTimeIso)).withReturnValues(ReturnValue.UPDATED_NEW);
            UpdateItemOutcome updated = DynamoDBLockProvider.this.table.updateItem(request);
            assert (unlockTimeIso.equals(updated.getItem().getString(DynamoDBLockProvider.LOCK_UNTIL)));
        }
    }
}

