/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import com.amazonaws.services.dynamodbv2.document.utils.ValueMap;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;
import org.jetbrains.annotations.NotNull;

public class DynamoDBLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    private static final String OBTAIN_LOCK_QUERY = "set lockUntil = :lockUntil, lockedAt = :lockedAt, lockedBy = :lockedBy";
    private static final String OBTAIN_LOCK_CONDITION = "lockUntil <= :lockedAt or attribute_not_exists(lockUntil)";
    private static final String RELEASE_LOCK_QUERY = "set lockUntil = :lockUntil";
    private final String hostname;
    private final Table table;

    public DynamoDBLockProvider(@NotNull Table table) {
        this.table = Objects.requireNonNull(table, "table can not be null");
        this.hostname = Utils.getHostname();
    }

    @NotNull
    public Optional<SimpleLock> lock(@NotNull LockConfiguration lockConfiguration) {
        String nowIso = Utils.toIsoString((Instant)this.now());
        String lockUntilIso = Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil());
        UpdateItemSpec request = new UpdateItemSpec().withPrimaryKey(ID, (Object)lockConfiguration.getName()).withUpdateExpression(OBTAIN_LOCK_QUERY).withConditionExpression(OBTAIN_LOCK_CONDITION).withValueMap((Map)new ValueMap().withString(":lockUntil", lockUntilIso).withString(":lockedAt", nowIso).withString(":lockedBy", this.hostname)).withReturnValues(ReturnValue.UPDATED_NEW);
        try {
            this.table.updateItem(request);
            return Optional.of(new DynamoDBLock(this.table, lockConfiguration));
        }
        catch (ConditionalCheckFailedException e) {
            return Optional.empty();
        }
    }

    private Instant now() {
        return ClockProvider.now();
    }

    private static final class DynamoDBLock
    extends AbstractSimpleLock {
        private final Table table;

        private DynamoDBLock(Table table, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.table = table;
        }

        public void doUnlock() {
            String unlockTimeIso = Utils.toIsoString((Instant)this.lockConfiguration.getUnlockTime());
            UpdateItemSpec request = new UpdateItemSpec().withPrimaryKey(DynamoDBLockProvider.ID, (Object)this.lockConfiguration.getName()).withUpdateExpression(DynamoDBLockProvider.RELEASE_LOCK_QUERY).withValueMap((Map)new ValueMap().withString(":lockUntil", unlockTimeIso)).withReturnValues(ReturnValue.UPDATED_NEW);
            this.table.updateItem(request);
        }
    }
}

